/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.expression;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.internal.p2.metadata.expression.Unary;
import org.eclipse.equinox.internal.p2.metadata.expression.Variable;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;
import org.eclipse.equinox.p2.metadata.expression.IExpressionVisitor;
import org.eclipse.equinox.p2.metadata.expression.IMemberProvider;

public abstract class Member
extends Unary {
    protected final Expression[] argExpressions;
    final String name;

    static Member createDynamicMember(Expression operand, String name) {
        return new DynamicMember(operand, name);
    }

    protected Member(Expression operand, String name, Expression[] args) {
        super(operand);
        this.name = name.intern();
        this.argExpressions = args;
    }

    @Override
    public boolean accept(IExpressionVisitor visitor) {
        if (super.accept(visitor)) {
            Expression[] expressionArray = this.argExpressions;
            int n = this.argExpressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                if (!expression.accept(visitor)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    @Override
    public int compareTo(Expression e) {
        int cmp = super.compareTo(e);
        if (cmp == 0 && (cmp = this.name.compareTo(((Member)e).name)) == 0) {
            cmp = Member.compare(this.argExpressions, ((Member)e).argExpressions);
        }
        return cmp;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            Member mo = (Member)o;
            return this.name.equals(mo.name) && Member.equals(this.argExpressions, mo.argExpressions);
        }
        return false;
    }

    @Override
    public int getExpressionType() {
        return 13;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getOperator() {
        return ".";
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    public int hashCode() {
        int result = 31 + this.name.hashCode();
        result = 31 * result + this.operand.hashCode();
        return 31 * result + Member.hashCode(this.argExpressions);
    }

    @Override
    public void toString(StringBuilder bld, Variable rootVariable) {
        if (this.operand != rootVariable) {
            Member.appendOperand(bld, rootVariable, this.operand, this.getPriority());
            bld.append('.');
        }
        bld.append(this.name);
        if (this.argExpressions.length > 0) {
            bld.append('(');
            Member.elementsToString(bld, rootVariable, this.argExpressions);
            bld.append(')');
        }
    }

    public static final class DynamicMember
    extends Member {
        private static final String GET_PREFIX = "get";
        private static final String IS_PREFIX = "is";
        private Method lastMethod;

        DynamicMember(Expression operand, String name) {
            super(operand, name, Expression.emptyArray);
        }

        @Override
        public Object evaluate(IEvaluationContext context) {
            return this.invoke(this.operand.evaluate(context));
        }

        public final Object invoke(Object self) {
            if (self instanceof IMemberProvider) {
                return ((IMemberProvider)self).getMember(this.name);
            }
            if (self == null) {
                throw new IllegalArgumentException("Cannot access member '" + this.name + "' in null");
            }
            DynamicMember dynamicMember = this;
            synchronized (dynamicMember) {
                Exception checked;
                Method method;
                this.lastMethod = method = this.lastMethod != null && this.lastMethod.getDeclaringClass().isInstance(self) ? this.lastMethod : this.findAccessibleMethod(self, this.name);
                try {
                    MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
                    return methodHandle.invoke(self);
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (IllegalAccessException e) {
                    checked = e;
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getTargetException();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    checked = (Exception)cause;
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    checked = (Exception)e;
                }
                throw new RuntimeException("Problem invoking " + method.getName() + " on a " + self.getClass().getName(), checked);
            }
        }

        private Collection<String> getMethodNames(String propertyName) {
            ArrayList<String> res = new ArrayList<String>(3);
            String n = propertyName;
            res.add(propertyName);
            if (!n.startsWith(GET_PREFIX) && !n.startsWith(IS_PREFIX)) {
                res.add(GET_PREFIX + Character.toUpperCase(n.charAt(0)) + n.substring(1));
                res.add(IS_PREFIX + Character.toUpperCase(n.charAt(0)) + n.substring(1));
            }
            return res;
        }

        private Method findAccessibleMethod(Object self, String propertyName) {
            Collection<String> methodNamesToTry = this.getMethodNames(propertyName);
            LinkedList typesToTry = new LinkedList();
            LinkedList<Method> notAccessibleMethods = new LinkedList<Method>();
            typesToTry.add(self.getClass());
            while (!typesToTry.isEmpty()) {
                Class currentClass = (Class)typesToTry.poll();
                for (String methodName : methodNamesToTry) {
                    try {
                        Method m = currentClass.getMethod(methodName, new Class[0]);
                        if (m.canAccess(self)) {
                            return m;
                        }
                        notAccessibleMethods.add(m);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                typesToTry.addAll(Arrays.asList(currentClass.getInterfaces()));
                Optional.ofNullable(currentClass.getSuperclass()).ifPresent(typesToTry::add);
            }
            if (!notAccessibleMethods.isEmpty()) {
                return (Method)notAccessibleMethods.peek();
            }
            throw new IllegalArgumentException("Cannot find accessor method for property '" + this.name + "' in a " + self.getClass().getName());
        }
    }

    public static class EmptyMember
    extends LengthMember {
        EmptyMember(Expression operand) {
            super(operand);
        }

        @Override
        public Object evaluate(IEvaluationContext context) {
            Object val = this.operand.evaluate(context);
            boolean empty = val instanceof Iterator ? !((Iterator)val).hasNext() : this.getLength(val) == 0;
            return empty;
        }
    }

    public static class LengthMember
    extends Member {
        LengthMember(Expression operand) {
            super(operand, "length", Expression.emptyArray);
        }

        @Override
        public Object evaluate(IEvaluationContext context) {
            int len = this.getLength(this.operand.evaluate(context));
            return len;
        }

        int getLength(Object val) {
            if (val == null) {
                return 0;
            }
            if (val.getClass().isArray()) {
                return Array.getLength(val);
            }
            if (val instanceof Collection) {
                return ((Collection)val).size();
            }
            if (val instanceof String) {
                return ((String)val).length();
            }
            if (val instanceof Map) {
                return ((Map)val).size();
            }
            return 0;
        }
    }
}

