/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.controls;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.controls.AbstractEmbeddedComposite;
import org.eclipse.rcptt.ui.editors.NamedElementEditorActions;
import org.eclipse.rcptt.ui.editors.TextViewerActions;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DescriptionComposite
extends AbstractEmbeddedComposite {
    private NamedElement element;
    private Composite control;
    private TextViewer descriptionControl;
    private Binding descriptionBinding;
    private NamedElementEditorActions.INamedElementActions actions;

    @Override
    protected void fillActions(IToolBarManager manager) {
        Action clearAction = new Action(){

            public void run() {
                DescriptionComposite.this.descriptionControl.getDocument().set("");
                DescriptionComposite.this.descriptionControl.getControl().setFocus();
            }
        };
        clearAction.setImageDescriptor(Images.getImageDescriptor("icons/panel/clear.gif"));
        clearAction.setToolTipText(Messages.DescriptionComposite_ClearToolTip);
        manager.add((IAction)clearAction);
    }

    public DescriptionComposite(NamedElement element) {
        this.element = element;
    }

    @Override
    public String getName() {
        return Messages.DescriptionComposite_Name;
    }

    @Override
    public Image getImage() {
        return Images.getImage("icons/file.gif");
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.control = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.control);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).applyTo(this.control);
        this.descriptionControl = new TextViewer(this.control, 2882);
        this.actions = new TextViewerActions(this.descriptionControl);
        GridDataFactory.fillDefaults().grab(true, true).hint(100, 50).applyTo(this.descriptionControl.getControl());
        this.update(this.element);
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    public void update(NamedElement element) {
        String descr;
        String doc;
        this.element = element;
        if (this.descriptionBinding != null) {
            this.descriptionBinding.dispose();
        }
        this.descriptionControl.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                String value = DescriptionComposite.this.descriptionControl.getDocument().get();
                if (value != null && value.trim().length() == 0) {
                    value = null;
                }
                String curDescr = DescriptionComposite.this.element.getDescription();
                if (value == null && curDescr != null) {
                    DescriptionComposite.this.element.setDescription(value);
                } else if (value != curDescr && !value.equals(curDescr)) {
                    DescriptionComposite.this.element.setDescription(value);
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        IChangeListener scenarioContentListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                String descr;
                String doc;
                if (DescriptionComposite.this.descriptionControl.getDocument() != null && !(doc = DescriptionComposite.this.descriptionControl.getDocument().get()).equals(descr = DescriptionComposite.this.element.getDescription())) {
                    DescriptionComposite.this.descriptionControl.getDocument().set(descr);
                }
            }
        };
        IObservableValue scriptContent = EMFObservables.observeValue((EObject)element, (EStructuralFeature)ScenarioPackage.Literals.SCENARIO__CONTENT);
        scriptContent.addChangeListener(scenarioContentListener);
        if (this.descriptionControl.getDocument() != null && !(doc = this.descriptionControl.getDocument().get()).equals(descr = this.element.getDescription()) && descr != null) {
            this.descriptionControl.getDocument().set(descr);
        }
        this.descriptionControl.getUndoManager().reset();
    }

    public TextViewer getDescriptionViewer() {
        return this.descriptionControl;
    }

    public StyledText getDescriptionControl() {
        return this.getDescriptionViewer().getTextWidget();
    }

    public NamedElementEditorActions.INamedElementActions getActions() {
        return this.actions;
    }
}

