/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rcptt.logging.IQ7Monitor;
import org.eclipse.rcptt.logging.Q7LoggingPlugin;

public abstract class BaseFileQ7Monitor
implements IQ7Monitor {
    static boolean logToConsole = false;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private List<IQ7Monitor.IQ7LogListener> listeners = null;
    protected Logger logger;

    public static void setLogToConsole(boolean value) {
        logToConsole = value;
    }

    protected abstract String getFailMessage();

    protected abstract FileHandler getFileHandle() throws IOException;

    @Override
    public synchronized void addListener(IQ7Monitor.IQ7LogListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IQ7Monitor.IQ7LogListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(IQ7Monitor.IQ7LogListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected int getLogFileCount() {
        return 10;
    }

    protected int getLogFileSize() {
        return 0xA00000;
    }

    protected void reinit() {
        try {
            this.disposeLogger();
            this.logger = Logger.getAnonymousLogger();
            this.logger.setLevel(Level.ALL);
            FileHandler fileHandler = this.getFileHandle();
            fileHandler.setFormatter(new Formatter(){
                private String lineSeparator = System.getProperty("line.separator");

                @Override
                public String format(LogRecord record) {
                    StringBuffer sb = new StringBuffer();
                    String idValue = BaseFileQ7Monitor.this.formatter.format(new Date(record.getMillis()));
                    sb.append(String.valueOf(idValue) + ": ");
                    String message = this.formatMessage(record);
                    message = message.replace("\n", this.lineSeparator);
                    sb.append(message);
                    sb.append(this.lineSeparator);
                    if (record.getThrown() != null) {
                        try {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            record.getThrown().printStackTrace(pw);
                            pw.close();
                            sb.append(sw.toString());
                        }
                        catch (Exception exception) {}
                    }
                    return sb.toString();
                }
            });
            this.logger.addHandler(fileHandler);
            this.log("############################## NEW SESSION #####################################", null);
        }
        catch (Exception e) {
            Q7LoggingPlugin.error(e.getMessage(), e);
        }
    }

    @Override
    public void log(String message) {
        this.log(message, null);
    }

    @Override
    public synchronized void log(String message, Throwable e) {
        if (logToConsole) {
            System.out.println(message);
            if (e != null) {
                e.printStackTrace();
            }
        }
        if (this.listeners != null) {
            for (IQ7Monitor.IQ7LogListener l : this.listeners) {
                l.added(message);
            }
        }
        if (this.logger == null) {
            this.reinit();
        }
        if (this.logger == null) {
            Q7LoggingPlugin.error(this.getFailMessage(), null);
            return;
        }
        this.logger.log(Level.ALL, message, e);
    }

    @Override
    public void close() {
        this.disposeLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeLogger() {
        Logger logger2 = null;
        BaseFileQ7Monitor baseFileQ7Monitor = this;
        synchronized (baseFileQ7Monitor) {
            logger2 = this.logger;
            this.logger = null;
        }
        if (logger2 != null) {
            Handler[] targets = logger2.getHandlers();
            int i = 0;
            while (i < targets.length) {
                Handler h = targets[i];
                logger2.removeHandler(h);
                try {
                    h.close();
                }
                catch (Exception exception) {}
                ++i;
            }
        }
    }

    @Override
    public void log(IStatus status) {
        if (logToConsole) {
            System.out.println(status.toString());
        }
        if (this.listeners != null) {
            for (IQ7Monitor.IQ7LogListener l : this.listeners) {
                l.added(status.getMessage());
            }
        }
        if (this.logger == null) {
            this.reinit();
        }
        if (this.logger == null) {
            Q7LoggingPlugin.error(this.getFailMessage(), null);
            return;
        }
        this.logger.log(Level.ALL, status.toString());
    }
}

