/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.rcptt.util.UtilPlugin;

public class KeysAndButtons {
    private static String POINT_ID = "org.eclipse.rcptt.util.keysExtension";
    private static IKeysAndButtonExtension extension;
    public static final String BUTTON_LEFT = "Left";
    public static final String BUTTON_RIGHT = "Right";
    public static final String BUTTON_MIDDLE = "Middle";
    public static final String BUTTON_4 = "Button4";
    public static final String BUTTON_5 = "Button5";
    private static Map<Integer, String> MODIFIERS;
    private static int[] ORDERED_MODIFIERS;
    private static int[] REVERSE_MODIFIERS;
    private static Map<Integer, String> BUTTON_NAMES_BY_MASK;
    private static Map<String, Integer> BUTTON_NUMBERS;
    private static int[] BUTTON_MASKS_BY_NUMBER;
    private static final Map<String, Integer> STATES_BY_NAME;
    private static final String[] BUTTON_NAMES;

    static {
        MODIFIERS = null;
        ORDERED_MODIFIERS = null;
        REVERSE_MODIFIERS = null;
        BUTTON_NAMES_BY_MASK = null;
        BUTTON_NUMBERS = null;
        BUTTON_MASKS_BY_NUMBER = null;
        STATES_BY_NAME = new HashMap<String, Integer>();
        for (Map.Entry<Integer, String> entry : KeysAndButtons.getModifiers().entrySet()) {
            STATES_BY_NAME.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<Integer, String> entry : KeysAndButtons.getButtonNamesByMask().entrySet()) {
            STATES_BY_NAME.put(entry.getValue(), entry.getKey());
        }
        String[] stringArray = new String[6];
        stringArray[1] = BUTTON_LEFT;
        stringArray[2] = BUTTON_MIDDLE;
        stringArray[3] = BUTTON_RIGHT;
        stringArray[4] = BUTTON_4;
        stringArray[5] = BUTTON_5;
        BUTTON_NAMES = stringArray;
    }

    public static int[] getOrderedModifiers() {
        if (ORDERED_MODIFIERS == null) {
            IKeysAndButtonExtension extension = KeysAndButtons.getExtension();
            ORDERED_MODIFIERS = new int[]{extension.getMod1(), extension.getMod2(), extension.getMod3(), extension.getMod4()};
        }
        return ORDERED_MODIFIERS;
    }

    public static int[] getReverseModifiers() {
        if (REVERSE_MODIFIERS == null) {
            int[] ordered = KeysAndButtons.getOrderedModifiers();
            int size = ordered.length - 1;
            REVERSE_MODIFIERS = new int[ordered.length];
            int i = size;
            while (i >= 0) {
                KeysAndButtons.REVERSE_MODIFIERS[size - i] = ordered[i];
                --i;
            }
        }
        return REVERSE_MODIFIERS;
    }

    public static Map<Integer, String> getModifiers() {
        if (MODIFIERS == null) {
            IKeysAndButtonExtension extension = KeysAndButtons.getExtension();
            LinkedHashMap<Integer, String> current = new LinkedHashMap<Integer, String>();
            current.put(extension.getMod1(), "M1");
            current.put(extension.getMod2(), "M2");
            current.put(extension.getMod3(), "M3");
            current.put(extension.getMod4(), "M4");
            MODIFIERS = Collections.unmodifiableMap(current);
        }
        return MODIFIERS;
    }

    private static Map<Integer, String> getButtonNamesByMask() {
        if (BUTTON_NAMES_BY_MASK == null) {
            IKeysAndButtonExtension extension = KeysAndButtons.getExtension();
            LinkedHashMap<Integer, String> current = new LinkedHashMap<Integer, String>();
            current.put(extension.getButton1(), BUTTON_LEFT);
            current.put(extension.getButton2(), BUTTON_MIDDLE);
            current.put(extension.getButton3(), BUTTON_RIGHT);
            current.put(extension.getButton4(), BUTTON_4);
            current.put(extension.getButton5(), BUTTON_5);
            BUTTON_NAMES_BY_MASK = Collections.unmodifiableMap(current);
        }
        return BUTTON_NAMES_BY_MASK;
    }

    private static Map<String, Integer> getButtonNumbers() {
        if (BUTTON_NUMBERS == null) {
            HashMap<String, Integer> current = new HashMap<String, Integer>();
            current.put(BUTTON_LEFT, 1);
            current.put(BUTTON_MIDDLE, 2);
            current.put(BUTTON_RIGHT, 3);
            current.put(BUTTON_4, 4);
            current.put(BUTTON_5, 5);
            BUTTON_NUMBERS = Collections.unmodifiableMap(current);
        }
        return BUTTON_NUMBERS;
    }

    private static int[] getButtonMasksByNumber() {
        if (BUTTON_MASKS_BY_NUMBER == null) {
            IKeysAndButtonExtension extension = KeysAndButtons.getExtension();
            int[] nArray = new int[6];
            nArray[1] = extension.getButton1();
            nArray[2] = extension.getButton2();
            nArray[3] = extension.getButton3();
            nArray[4] = extension.getButton4();
            nArray[5] = extension.getButton5();
            BUTTON_MASKS_BY_NUMBER = nArray;
        }
        return BUTTON_MASKS_BY_NUMBER;
    }

    public static int getButtonMask(int button) throws CoreException {
        if (button <= 0 || button >= KeysAndButtons.getButtonMasksByNumber().length) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.util", String.format("Cannot find button mast for button #%d", button)));
        }
        return KeysAndButtons.getButtonMasksByNumber()[button];
    }

    public static int getButtonMaskSafe(int button) {
        if (button <= 0 || button >= KeysAndButtons.getButtonMasksByNumber().length) {
            return 0;
        }
        return KeysAndButtons.getButtonMasksByNumber()[button];
    }

    public static String getButtonName(int button) throws CoreException {
        if (button <= 0 || button >= BUTTON_NAMES.length) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.util", String.format("Cannot find button name for button #%d", button)));
        }
        return BUTTON_NAMES[button];
    }

    public static String getButtonNameSafe(int button, String def) {
        if (button <= 0 || button >= BUTTON_NAMES.length) {
            return def;
        }
        return BUTTON_NAMES[button];
    }

    public static String getButtonNameSafe(int button) {
        return KeysAndButtons.getButtonNameSafe(button, BUTTON_LEFT);
    }

    public static int getButtonNumber(String name) throws CoreException {
        if (name != null && name.length() > 0) {
            name = String.format("%c%s", Character.valueOf(name.charAt(0)), name.substring(1).toLowerCase());
        }
        if (!KeysAndButtons.getButtonNumbers().containsKey(name)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.util", String.format("Unknown button name '%s'", name)));
        }
        return KeysAndButtons.getButtonNumbers().get(name);
    }

    public static String stateMaskToStr(int stateMask) {
        ArrayList<String> result = new ArrayList<String>();
        KeysAndButtons.processMap(KeysAndButtons.getModifiers(), stateMask, result);
        KeysAndButtons.processMap(KeysAndButtons.getButtonNamesByMask(), stateMask, result);
        return StringUtils.join('+', result);
    }

    public static int stateMaskFromStr(String str) throws CoreException {
        if (str == null || str.length() == 0) {
            return 0;
        }
        String errorMessage = KeysAndButtons.validateStateStr(str);
        if (errorMessage != null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui", errorMessage));
        }
        int result = 0;
        for (String entry : StringUtils.split('+', str)) {
            result |= STATES_BY_NAME.get(entry).intValue();
        }
        return result;
    }

    public static String validateStateStr(String state) {
        if (state == null || state.length() == 0) {
            return null;
        }
        for (String entry : StringUtils.split('+', state)) {
            if (STATES_BY_NAME.containsKey(entry)) continue;
            return String.format("Cannot parse state '%s': unknown entry '%s'", state, entry);
        }
        return null;
    }

    private static void processMap(Map<Integer, String> map, int stateMask, List<String> acc) {
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            if ((stateMask & entry.getKey()) == 0) continue;
            acc.add(entry.getValue());
        }
    }

    private static IKeysAndButtonExtension getExtension() {
        if (extension == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(POINT_ID);
            if (elements.length < 1) {
                return null;
            }
            try {
                extension = (IKeysAndButtonExtension)elements[0].createExecutableExtension("class");
            }
            catch (CoreException e) {
                UtilPlugin.log("Error while get key stroke extension.", e);
            }
        }
        return extension;
    }

    public static interface IKeysAndButtonExtension {
        public int getMod1();

        public int getMod2();

        public int getMod3();

        public int getMod4();

        public int getButton1();

        public int getButton2();

        public int getButton3();

        public int getButton4();

        public int getButton5();
    }
}

