/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.rcptt.core.ecl.core.model.ExecutionPhase;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.PrepareExecutionWrapper;
import org.eclipse.rcptt.internal.ui.StateImageProvider;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.reporting.core.TimeFormatHelper;
import org.eclipse.swt.graphics.Image;

public class ExecutionLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public Image getImage(Object element) {
        IExecutable executable = this.cast(element);
        try {
            if (executable.getType() == 0) {
                return StateImageProvider.TEST.getStateImage(executable.getStatus(), executable.getResultStatus());
            }
            if (executable.getType() == 1) {
                return StateImageProvider.CONTEXT.getStateImage(executable.getStatus(), executable.getResultStatus());
            }
            if (executable.getType() == 3) {
                return StateImageProvider.VERIFICATION.getStateImage(executable.getStatus(), executable.getResultStatus());
            }
            if (executable.getType() == 2) {
                return StateImageProvider.SUITE.getStateImage(executable.getStatus(), executable.getResultStatus());
            }
        }
        catch (CoreException e) {
            RcpttPlugin.getDefault().getLog().log(e.getStatus());
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        List variantName;
        IExecutable executable = this.cast(element);
        StyledString styledString = new StyledString(executable.getName());
        if (executable instanceof PrepareExecutionWrapper && (variantName = ((PrepareExecutionWrapper)executable).getVariantName()) != null && !variantName.isEmpty()) {
            styledString.append(" (" + Joiner.on((char)',').join((Iterable)variantName) + ")", StyledString.DECORATIONS_STYLER);
        }
        if (executable.getPhase() != ExecutionPhase.AUTO) {
            styledString.append(" ", StyledString.DECORATIONS_STYLER).append(executable.getPhase().toString(), StyledString.DECORATIONS_STYLER);
        }
        if (executable.getStatus() == IExecutable.State.COMPLETED && !executable.getResultStatus().matches(8)) {
            styledString.append(" (", StyledString.COUNTER_STYLER);
            long time = executable.getTime();
            styledString.append(TimeFormatHelper.format((long)time), StyledString.COUNTER_STYLER);
            styledString.append(")", StyledString.COUNTER_STYLER);
        }
        try {
            String[] contexts;
            IQ7Project project;
            IQ7ProjectMetadata metadata;
            String id;
            IQ7NamedElement actualElement = executable.getActualElement();
            if (!actualElement.getResource().getProject().isOpen()) {
                return styledString;
            }
            if (actualElement != null && actualElement.exists() && (id = executable.getActualElement().getID()) != null && (metadata = (project = executable.getActualElement().getQ7Project()).getMetadata()) != null && metadata.exists() && (contexts = metadata.getContexts()) != null && Arrays.asList(contexts).contains(id)) {
                styledString.append(" (default context)", StyledString.DECORATIONS_STYLER);
            }
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)e);
        }
        return styledString;
    }

    public String getText(Object element) {
        return this.getStyledText(element).toString();
    }

    private IExecutable cast(Object element) {
        return (IExecutable)element;
    }
}

