/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Win32DPIUtils;
import org.eclipse.swt.internal.gdip.Gdip;

public class Transform
extends Resource {
    private Map<Integer, TransformHandle> zoomToHandle = new HashMap<Integer, TransformHandle>();
    private List<Operation> operations = new ArrayList<Operation>();
    private boolean isDestroyed;

    public Transform(Device device) {
        this(device, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public Transform(Device device, float[] elements) {
        this(device, Transform.checkTransform(elements)[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
    }

    public Transform(Device device, float m11, float m12, float m21, float m22, float dx, float dy) {
        super(device);
        this.device.checkGDIP();
        this.storeAndApplyOperationForAllHandles(new SetElementsOperation(m11, m12, m21, m22, dx, dy));
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    static float[] checkTransform(float[] elements) {
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        return elements;
    }

    @Override
    void destroy() {
        this.device.deregisterResourceWithZoomSupport(this);
        this.zoomToHandle.values().forEach(TransformHandle::destroy);
        this.zoomToHandle.clear();
        this.isDestroyed = true;
    }

    @Override
    void destroyHandlesExcept(Set<Integer> zoomLevels) {
        this.zoomToHandle.values().forEach(TransformHandle::destroy);
        this.zoomToHandle.clear();
    }

    public void getElements(float[] elements) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        this.applyUsingAnyHandle(transformHandle -> {
            Gdip.Matrix_GetElements(transformHandle.handle, elements);
            Device drawable = this.getDevice();
            int zoom = transformHandle.zoom;
            fArray[4] = Win32DPIUtils.pixelToPoint((Drawable)drawable, elements[4], zoom);
            fArray[5] = Win32DPIUtils.pixelToPoint((Drawable)drawable, elements[5], zoom);
            return true;
        });
    }

    public void identity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.operations.clear();
        this.storeAndApplyOperationForAllHandles(new SetElementsOperation(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
    }

    public void invert() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.storeAndApplyOperationForAllHandles(new InvertOperation());
    }

    @Override
    public boolean isDisposed() {
        return this.isDestroyed;
    }

    public boolean isIdentity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.applyUsingAnyHandle(transformHandle -> Gdip.Matrix_IsIdentity(transformHandle.handle));
    }

    public void multiply(Transform matrix) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (matrix == null) {
            SWT.error(4);
        }
        if (matrix.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForAllHandles(new MultiplyOperation(matrix));
    }

    public void rotate(float angle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.storeAndApplyOperationForAllHandles(new RotateOperation(angle));
    }

    public void scale(float scaleX, float scaleY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.storeAndApplyOperationForAllHandles(new ScaleOperation(scaleX, scaleY));
    }

    public void setElements(float m11, float m12, float m21, float m22, float dx, float dy) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.operations.clear();
        this.storeAndApplyOperationForAllHandles(new SetElementsOperation(m11, m12, m21, m22, dx, dy));
    }

    public void shear(float shearX, float shearY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.storeAndApplyOperationForAllHandles(new ShearOperation(shearX, shearY));
    }

    public void transform(float[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        Device drawable = this.getDevice();
        this.applyUsingAnyHandle(transformHandle -> {
            int length = pointArray.length;
            int i = 0;
            while (i < length) {
                fArray[i] = Win32DPIUtils.pointToPixel(drawable, pointArray[i], transformHandle.zoom);
                ++i;
            }
            Gdip.Matrix_TransformPoints(transformHandle.handle, pointArray, length / 2);
            i = 0;
            while (i < length) {
                fArray[i] = Win32DPIUtils.pixelToPoint(drawable, pointArray[i], transformHandle.zoom);
                ++i;
            }
            return pointArray;
        });
    }

    public void translate(float offsetX, float offsetY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        this.storeAndApplyOperationForAllHandles(new TranslateOperation(offsetX, offsetY));
    }

    private void storeAndApplyOperationForAllHandles(Operation operation) {
        this.operations.add(operation);
        this.zoomToHandle.forEach((zoom, handle) -> operation.apply((TransformHandle)handle));
    }

    private <T> T applyUsingAnyHandle(Function<TransformHandle, T> function) {
        if (this.zoomToHandle.isEmpty()) {
            TransformHandle temporaryHandle = this.newTransformHandle(DPIUtil.getDeviceZoom());
            try {
                T t = function.apply(temporaryHandle);
                return t;
            }
            finally {
                temporaryHandle.destroy();
            }
        }
        return function.apply(this.zoomToHandle.values().iterator().next());
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Transform {*DISPOSED*}";
        }
        float[] elements = new float[6];
        this.getElements(elements);
        return "Transform {" + elements[0] + "," + elements[1] + "," + elements[2] + "," + elements[3] + "," + elements[4] + "," + elements[5] + "}";
    }

    private TransformHandle newTransformHandle(int zoom) {
        long newHandle = Gdip.Matrix_new(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (newHandle == 0L) {
            SWT.error(2);
        }
        TransformHandle newTransformHandle = new TransformHandle(newHandle, zoom);
        for (Operation operation : this.operations) {
            operation.apply(newTransformHandle);
        }
        return newTransformHandle;
    }

    private TransformHandle getTransformHandle(int zoom) {
        if (!this.zoomToHandle.containsKey(zoom)) {
            TransformHandle newHandle = this.newTransformHandle(zoom);
            this.zoomToHandle.put(zoom, newHandle);
            return newHandle;
        }
        return this.zoomToHandle.get(zoom);
    }

    long getHandle(int zoom) {
        return this.getTransformHandle((int)zoom).handle;
    }

    private record InvertOperation() implements Operation
    {
        @Override
        public void apply(TransformHandle transformHandle) {
            long handle = transformHandle.handle;
            if (Gdip.Matrix_Invert(handle) != 0) {
                SWT.error(10);
            }
        }
    }

    private class MultiplyOperation
    implements Operation {
        private final float[] elements = new float[6];

        public MultiplyOperation(Transform matrix) {
            matrix.getElements(this.elements);
        }

        @Override
        public void apply(TransformHandle transformHandle) {
            long handle = transformHandle.handle;
            int zoom = transformHandle.zoom;
            long newHandle = Gdip.Matrix_new(this.elements[0], this.elements[1], this.elements[2], this.elements[3], Win32DPIUtils.pointToPixel(this.elements[4], zoom), Win32DPIUtils.pointToPixel(this.elements[5], zoom));
            if (newHandle == 0L) {
                SWT.error(2);
            }
            try {
                Gdip.Matrix_Multiply(handle, newHandle, 0);
            }
            finally {
                Gdip.Matrix_delete(newHandle);
            }
        }
    }

    private static interface Operation {
        public void apply(TransformHandle var1);
    }

    private record RotateOperation(float angle) implements Operation
    {
        @Override
        public void apply(TransformHandle transformHandle) {
            long handle = transformHandle.handle;
            Gdip.Matrix_Rotate(handle, this.angle, 0);
        }
    }

    private record ScaleOperation(float scaleX, float scaleY) implements Operation
    {
        @Override
        public void apply(TransformHandle transformHandle) {
            long handle = transformHandle.handle;
            Gdip.Matrix_Scale(handle, this.scaleX, this.scaleY, 0);
        }
    }

    private class SetElementsOperation
    implements Operation {
        private final float m11;
        private final float m12;
        private final float m21;
        private final float m22;
        private final float dx;
        private final float dy;

        public SetElementsOperation(float m11, float m12, float m21, float m22, float dx, float dy) {
            this.m11 = m11;
            this.m12 = m12;
            this.m21 = m21;
            this.m22 = m22;
            this.dx = dx;
            this.dy = dy;
        }

        @Override
        public void apply(TransformHandle transformHandle) {
            Device drawable = Transform.this.getDevice();
            long handle = transformHandle.handle;
            int zoom = transformHandle.zoom;
            Gdip.Matrix_SetElements(handle, this.m11, this.m12, this.m21, this.m22, Win32DPIUtils.pointToPixel((Drawable)drawable, this.dx, zoom), Win32DPIUtils.pointToPixel((Drawable)drawable, this.dy, zoom));
        }
    }

    private record ShearOperation(float shearX, float shearY) implements Operation
    {
        @Override
        public void apply(TransformHandle transformHandle) {
            long handle = transformHandle.handle;
            Gdip.Matrix_Shear(handle, this.shearX, this.shearY, 0);
        }
    }

    private record TransformHandle(long handle, int zoom) {
        void destroy() {
            Gdip.Matrix_delete(this.handle);
        }
    }

    private class TranslateOperation
    implements Operation {
        private final float offsetX;
        private final float offsetY;

        public TranslateOperation(float offsetX, float offsetY) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }

        @Override
        public void apply(TransformHandle transformHandle) {
            Device drawable = Transform.this.getDevice();
            long handle = transformHandle.handle;
            int zoom = transformHandle.zoom;
            Gdip.Matrix_Translate(handle, Win32DPIUtils.pointToPixel((Drawable)drawable, this.offsetX, zoom), Win32DPIUtils.pointToPixel((Drawable)drawable, this.offsetY, zoom), 0);
        }
    }
}

