/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ContextExecutable;
import org.eclipse.rcptt.internal.launching.reporting.ReportMaker;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.core.ReportHelper;

public class UnresolvedContextExecutable
extends ContextExecutable {
    public UnresolvedContextExecutable(AutLaunch launch, IContext context, boolean debug) {
        super(launch, context, debug);
    }

    @Override
    protected IStatus doExecute() throws CoreException, InterruptedException {
        Context context = (Context)this.getActualElement().getModifiedNamedElement();
        Q7Info info = ReportHelper.createInfo();
        info.setType(ItemKind.CONTEXT);
        info.setTags(context.getTags());
        info.setId(context.getId());
        info.setDescription(context.getDescription());
        ImmutableMap props = ImmutableMap.of((Object)"q7", (Object)info);
        ReportMaker.beginReportNode(this.getName(), (Map<String, EObject>)props, this.launch);
        ReportMaker.endReportNode(false, this.launch, RcpttPlugin.createProcessStatus((int)4, (String)"Context is unresolved"));
        return new Status(4, "org.eclipse.rcptt.launching", "Context could not be resolved:" + this.getName());
    }
}

