/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.search.Matcher;

public class SearchJob
extends Job {
    private final List<ResultListener> listeners = new ArrayList<ResultListener>();
    private final List<Matcher> matchers;
    private String query = "";

    public SearchJob() {
        super(Messages.SearchJob_Name);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        this.setUser(true);
        this.matchers = new ArrayList<Matcher>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.rcptt.ui.searchMatchers");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            try {
                this.matchers.add((Matcher)el.createExecutableExtension("class"));
            }
            catch (CoreException e) {
                Q7UIPlugin.log(e);
            }
            ++n2;
        }
    }

    protected IStatus run(IProgressMonitor pm) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm);
        try {
            this.doSearch(monitor);
        }
        finally {
            pm.done();
        }
        return Status.OK_STATUS;
    }

    private void doSearch(SubMonitor monitor) {
        IQ7NamedElement[] allElements = Q7SearchCore.findAllElements();
        monitor.beginTask(Messages.SearchJob_TaskName, allElements.length);
        IQ7NamedElement[] iQ7NamedElementArray = allElements;
        int n = allElements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement iq7NamedElement = iQ7NamedElementArray[n2];
            if (this.searchInObject(iq7NamedElement, monitor.newChild(1))) {
                this.fireAdded(iq7NamedElement);
            }
            ++n2;
        }
    }

    private void fireAdded(IQ7NamedElement o) {
        for (ResultListener listener : this.listeners) {
            listener.resultAdded(o);
        }
    }

    private boolean searchInObject(IQ7NamedElement o, SubMonitor monitor) {
        monitor.beginTask(Messages.SearchJob_TaskName, this.matchers.size());
        for (Matcher matcher : this.matchers) {
            if (monitor.isCanceled()) {
                return false;
            }
            SubMonitor child = monitor.newChild(1);
            child.beginTask("Match", 100);
            try {
                if (!matcher.matches(o, this.query, child)) continue;
                return true;
            }
            finally {
                child.done();
            }
        }
        monitor.done();
        return false;
    }

    public void addResultListener(ResultListener listener) {
        this.listeners.add(listener);
    }

    public void setQuery(String query) {
        this.query = query.toLowerCase();
    }

    public static interface ResultListener {
        public void resultAdded(IQ7NamedElement var1);
    }
}

