/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.editors.ecl.CommandNameRule;
import org.eclipse.rcptt.ui.editors.ecl.EclLangUtil;
import org.eclipse.rcptt.ui.editors.ecl.EditorToolkit;
import org.eclipse.rcptt.ui.editors.ecl.EnhancedRuleScanner;
import org.eclipse.rcptt.ui.editors.ecl.SingleTokenScanner;

public class EclEditorToolkit
extends EditorToolkit {
    private static final EclEditorToolkit INSTANCE = new EclEditorToolkit();

    public static EclEditorToolkit getInstance() {
        return INSTANCE;
    }

    private EclEditorToolkit() {
    }

    @Override
    public IPreferenceStore getPreferenceStore() {
        return Q7UIPlugin.getDefault().getPreferenceStore();
    }

    @Override
    public String[] getContentTypes() {
        return new String[]{"__dftl_partition_content_type", "__ecl_string", "__ecl_comment"};
    }

    @Override
    public EnhancedRuleScanner getScanner(String ct) {
        if (ct.equals("__dftl_partition_content_type")) {
            return new EnhancedRuleScanner(this){

                @Override
                protected String[] getProperties() {
                    return new String[]{"__ecl_style_commandName", "__ecl_style_paramName", "__ecl_style_def"};
                }

                @Override
                protected List<IRule> createRules() {
                    ArrayList<IRule> rules = new ArrayList<IRule>();
                    Token defaultToken = this.getToken("__ecl_style_def");
                    rules.add((IRule)new CommandNameRule(){

                        public IToken getSuccessToken() {
                            return this.getToken("__ecl_style_commandName");
                        }

                        @Override
                        public IToken getDefaultReturnToken() {
                            return this.getToken("__ecl_style_commandName");
                        }
                    });
                    rules.add((IRule)new WordRule(new IWordDetector(){

                        public boolean isWordStart(char c) {
                            return EclLangUtil.isParamNameStart(c);
                        }

                        public boolean isWordPart(char c) {
                            return EclLangUtil.isParamNamePart(c);
                        }
                    }, (IToken)this.getToken("__ecl_style_paramName")));
                    this.setDefaultReturnToken((IToken)defaultToken);
                    return rules;
                }
            };
        }
        if (ct.equals("__ecl_string")) {
            return new SingleTokenScanner(this){

                @Override
                protected String getSingleProperty() {
                    return "__ecl_style_string";
                }
            };
        }
        if (ct.equals("__ecl_comment")) {
            return new SingleTokenScanner(this){

                @Override
                protected String getSingleProperty() {
                    return "__ecl_style_comment";
                }
            };
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String[] getPartitions() {
        return new String[]{"__ecl_string", "__ecl_comment"};
    }

    @Override
    public IPartitionTokenScanner getPartitionScanner() {
        RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner();
        Token commentToken = new Token((Object)"__ecl_comment");
        Token stringToken = new Token((Object)"__ecl_string");
        scanner.setPredicateRules(new IPredicateRule[]{new EndOfLineRule("//", (IToken)commentToken), new MultiLineRule("/*", "*/", (IToken)commentToken, '\u0000', true), new SingleLineRule("\"", "\"", (IToken)stringToken, '\\'), new SingleLineRule("'", "'", (IToken)stringToken, '\\')});
        return scanner;
    }

    static interface Partition {
        public static final String def = "__dftl_partition_content_type";
        public static final String comment = "__ecl_comment";
        public static final String string = "__ecl_string";
    }

    static interface Style {
        public static final String commandName = "__ecl_style_commandName";
        public static final String paramName = "__ecl_style_paramName";
        public static final String def = "__ecl_style_def";
        public static final String comment = "__ecl_style_comment";
        public static final String string = "__ecl_style_string";
    }
}

