/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.configuration;

import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.launching.EclipseApplicationLaunchConfiguration;
import org.eclipse.rcptt.internal.launching.aut.LaunchInfoCache;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchMonitor;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformInitializer;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.launching.configuration.LaunchConfigurationUtils;
import org.eclipse.rcptt.launching.ext.BundleStart;
import org.eclipse.rcptt.launching.ext.OriginalOrderProperties;
import org.eclipse.rcptt.launching.ext.Q7ExternalLaunchDelegate;
import org.eclipse.rcptt.launching.ext.Q7LaunchDelegateUtils;
import org.eclipse.rcptt.launching.internal.target.TargetPlatformHelper;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.osgi.framework.BundleException;

public class Q7LaunchConfigurationDelegate
extends EclipseApplicationLaunchConfiguration {
    private static final String SECURE_STORAGE_FILE_NAME = "secure_storage";
    private ILaunch launch;

    private ILaunchConfiguration getTargetConfiguration(ILaunchConfiguration configuration) throws CoreException {
        return LaunchConfigurationUtils.findLaunchConfiguration(configuration.getAttribute("target-configuration", ""), "org.eclipse.pde.ui.RuntimeWorkbench");
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block7: {
            this.launch = launch;
            monitor.beginTask("", 2);
            Q7ExtLaunchMonitor waiter = new Q7ExtLaunchMonitor(launch);
            try {
                ILaunchConfiguration targetConfig = this.getTargetConfiguration(configuration);
                String targetConfigName = targetConfig.getName();
                ILaunchConfigurationWorkingCopy configurationWc = configuration.getWorkingCopy();
                configurationWc.setAttributes(targetConfig.getAttributes());
                configurationWc.setAttribute("target-configuration", targetConfigName);
                configurationWc.doSave();
                super.launch(configuration, mode, launch, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                waiter.wait(monitor, TeslaLimits.getAUTStartupTimeout() / 1000);
            }
            catch (CoreException e) {
                waiter.handle((Exception)((Object)e));
                if (e.getStatus().getSeverity() != 8) {
                    throw e;
                }
                waiter.dispose();
                break block7;
            }
            catch (RuntimeException e) {
                try {
                    waiter.handle((Exception)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    waiter.dispose();
                    throw throwable;
                }
            }
            waiter.dispose();
        }
        monitor.done();
    }

    protected void manageLaunch(ILaunch launch) {
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IStatus status;
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)7);
        MultiStatus warnings = new MultiStatus(((Object)((Object)this)).getClass(), 0, "Launching " + configuration.getName());
        try {
            Job.getJobManager().join((Object)"q7.clean.bundle.pool.job", (IProgressMonitor)sm.split(1));
        }
        catch (Exception e1) {
            warnings.add(Status.error((String)"Failed to wait for bundle pool clear job", (Throwable)e1));
        }
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        String targetName = configuration.getName() + " with RCPTT";
        ITargetPlatformHelper helper = Q7TargetPlatformManager.findTarget((ILaunchConfiguration)configuration, (IProgressMonitor)sm.split(1));
        if (helper != null) {
            status = helper.resolve((IProgressMonitor)sm.split(1));
            if (status.matches(8)) {
                throw new CoreException(status);
            }
            if (status.matches(4)) {
                helper.delete();
                helper = null;
            } else if (!status.isOK()) {
                warnings.add(status);
            }
        }
        if (helper == null) {
            helper = TargetPlatformManager.getCurrentTargetPlatformCopy((String)targetName);
            status = helper.resolve((IProgressMonitor)sm.split(1));
            if (status.matches(8)) {
                throw new CoreException(status);
            }
            if (status.matches(4)) {
                helper.delete();
                helper = null;
                throw new CoreException(status);
            }
            if (!status.isOK()) {
                warnings.add(status);
            }
            if ((status = Q7TargetPlatformInitializer.initialize((ITargetPlatformHelper)helper, (IProgressMonitor)sm.split(1))).matches(8)) {
                throw new CoreException(status);
            }
            if (status.matches(4)) {
                helper.delete();
                helper = null;
                throw new CoreException(status);
            }
            if (!status.isOK()) {
                warnings.add(status);
            }
            helper.save();
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            Q7TargetPlatformManager.setHelper((ILaunchConfigurationWorkingCopy)wc, (ITargetPlatformHelper)helper);
            configuration = wc.doSave();
        }
        if (helper != null) {
            info.target = helper;
        }
        try {
            boolean bl = super.preLaunchCheck(configuration, mode, (IProgressMonitor)sm.split(1));
            return bl;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public String[] getVMArguments(ILaunchConfiguration config) throws CoreException {
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)config);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(super.getVMArguments(config)));
        ITargetPlatformHelper target = (ITargetPlatformHelper)info.target;
        Q7ExternalLaunchDelegate.massageVmArguments((ILaunchConfiguration)config, args, (ITargetPlatformHelper)target, (String)this.launch.getAttribute("org.eclipse.rcptt.launching.ATTR_AUT_LAUNCH_ID"));
        info.vmArgs = args.toArray(new String[args.size()]);
        return info.vmArgs;
    }

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        if (info.programArgs != null) {
            return info.programArgs;
        }
        ArrayList<Object> programArgs = new ArrayList<Object>();
        programArgs.addAll(Arrays.asList(super.getProgramArguments(configuration)));
        try {
            File config = new File(this.getConfigDir(configuration), "config.ini");
            OriginalOrderProperties props = new OriginalOrderProperties();
            Throwable throwable = null;
            Throwable throwable2 = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(config));){
                props.load((InputStream)in);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            String targetPlatformProfilePath = ((ITargetPlatformHelper)info.target).getTargetPlatformProfilePath();
            if (targetPlatformProfilePath != null) {
                props.setProperty("osgi.install.area", targetPlatformProfilePath);
            }
            props.setProperty("osgi.bundles", Q7LaunchDelegateUtils.computeOSGiBundles((Map)Q7ExternalLaunchDelegate.getBundlesToLaunch((LaunchInfoCache.CachedInfo)info).latestVersionsOnly));
            throwable2 = null;
            Object var8_12 = null;
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(config));){
                props.store((OutputStream)out, "Configuration File");
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            new File(config.getParent(), ".p2").mkdirs();
        }
        catch (IOException e) {
            throw new CoreException(Q7ExtLaunchingPlugin.status((Throwable)e));
        }
        if (configuration.getAttribute("override-secure-storage", true)) {
            programArgs.add("-eclipse.keyring");
            programArgs.add(this.getConfigDir(configuration).toString() + "/secure_storage");
        }
        info.programArgs = programArgs.toArray(new String[programArgs.size()]);
        return programArgs.toArray(new String[programArgs.size()]);
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        super.preLaunchCheck(configuration, launch, (IProgressMonitor)sm.split(1));
        if (monitor.isCanceled()) {
            return;
        }
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        TargetPlatformHelper target = (TargetPlatformHelper)info.target;
        Q7ExternalLaunchDelegate.BundlesToLaunchCollector collector = new Q7ExternalLaunchDelegate.BundlesToLaunchCollector();
        for (Map.Entry entry : Q7LaunchDelegateUtils.getEclipseApplicationModels((EclipseApplicationLaunchConfiguration)this).entrySet()) {
            try {
                collector.addInstallationBundle((IPluginModelBase)entry.getKey(), BundleStart.fromModelString((String)((String)entry.getValue())));
            }
            catch (IOException | BundleException e) {
                throw new CoreException(Status.error((String)("Failed to process " + ((IPluginModelBase)entry.getKey()).getInstallLocation()), (Throwable)e));
            }
        }
        SubMonitor locationsMonitor = SubMonitor.convert((IProgressMonitor)sm.split(1), (int)target.size());
        target.getModels().forEach(m -> {
            locationsMonitor.subTask(m.model().getPluginBase().getName());
            collector.addPluginBundle(m.model(), m.startLevel());
            locationsMonitor.split(1);
        });
        Q7ExternalLaunchDelegate.BundlesToLaunch bundles = collector.getResult();
        Q7ExternalLaunchDelegate.removeUnresolved((Q7ExternalLaunchDelegate.BundlesToLaunch)bundles);
        Q7ExternalLaunchDelegate.setBundlesToLaunch((LaunchInfoCache.CachedInfo)info, (Q7ExternalLaunchDelegate.BundlesToLaunch)bundles);
        Q7LaunchDelegateUtils.setDelegateFields((EclipseApplicationLaunchConfiguration)this, (Map)bundles.fModels, (Map)Maps.transformValues((Map)bundles.fAllBundles.asMap(), ArrayList::new));
        monitor.done();
    }
}

