/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.ISession;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiScope;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiScope;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.ui.internal.actions.ActionMessages;
import org.eclipse.pde.api.tools.ui.internal.actions.DeltaSession;

public class CompareOperation
extends Job {
    private IApiBaseline baseline = null;
    private IStructuredSelection selection = null;

    public CompareOperation(IApiBaseline baseline, IStructuredSelection selection) {
        super(ActionMessages.CompareWithAction_comparing_apis);
        this.baseline = baseline;
        Assert.isNotNull((Object)this.baseline);
        this.selection = selection;
    }

    protected IStatus run(IProgressMonitor monitor) {
        block12: {
            monitor.beginTask(ActionMessages.CompareDialogCollectingElementTaskName, -1);
            String baselineName = this.baseline.getName();
            ApiScope scope = CompareOperation.walkStructureSelection(this.selection);
            try {
                IDelta delta;
                block11: {
                    monitor.subTask(ActionMessages.CompareDialogComputeDeltasTaskName);
                    try {
                        delta = ApiComparator.compare((IApiScope)scope, (IApiBaseline)this.baseline, (int)1, (boolean)false, (IProgressMonitor)monitor);
                        if (delta != null) break block11;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    catch (CoreException e) {
                        ApiPlugin.log((Throwable)e);
                        break block12;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        break block12;
                    }
                }
                int size = this.selection.size();
                String description = NLS.bind((String)ActionMessages.CompareWithAction_compared_with_against, (Object[])new Object[]{size, baselineName, delta.getChildren().length});
                if (size == 0) {
                    description = ActionMessages.CompareWithAction_compared_against_nothing;
                } else if (size == 1) {
                    Object selectedElement = this.selection.getFirstElement();
                    String elementName = selectedElement instanceof IJavaElement ? ((IJavaElement)selectedElement).getElementName() : selectedElement.toString();
                    description = NLS.bind((String)ActionMessages.CompareWithAction_compared_project_with, (Object[])new Object[]{elementName, baselineName, delta.getChildren().length});
                }
                ApiPlugin.getDefault().getSessionManager().addSession((ISession)new DeltaSession(description, delta, baselineName), true);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
        return Status.CANCEL_STATUS;
    }

    public static ApiScope walkStructureSelection(IStructuredSelection structuredSelection) {
        Object[] selected = structuredSelection.toArray();
        ApiScope scope = new ApiScope();
        IApiBaseline workspaceBaseline = ApiBaselineManager.getManager().getWorkspaceBaseline();
        if (workspaceBaseline == null) {
            return scope;
        }
        Arrays.sort(selected, (o1, o2) -> {
            if (o1 instanceof IJavaElement && o2 instanceof IJavaElement) {
                IJavaElement element = (IJavaElement)o1;
                IJavaElement element2 = (IJavaElement)o2;
                return element.getElementType() - element2.getElementType();
            }
            return 0;
        });
        int length = selected.length;
        int i = 0;
        while (i < length) {
            Object currentSelection = selected[i];
            if (currentSelection instanceof IJavaElement) {
                IJavaElement element = (IJavaElement)currentSelection;
                IJavaProject javaProject = element.getJavaProject();
                try {
                    switch (element.getElementType()) {
                        case 5: {
                            ICompilationUnit compilationUnit = (ICompilationUnit)element;
                            IApiComponent apiComponent = workspaceBaseline.getApiComponent(javaProject.getElementName());
                            if (apiComponent != null) {
                                CompareOperation.addElementFor(compilationUnit, apiComponent, scope);
                            }
                            break;
                        }
                        case 4: {
                            IPackageFragment fragment = (IPackageFragment)element;
                            IApiComponent apiComponent = workspaceBaseline.getApiComponent(javaProject.getElementName());
                            IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)fragment.getAncestor(3);
                            boolean isArchive = false;
                            if (packageFragmentRoot != null) {
                                isArchive = packageFragmentRoot.isArchive();
                            }
                            if (apiComponent != null) {
                                CompareOperation.addElementFor(fragment, isArchive, apiComponent, scope);
                            }
                            break;
                        }
                        case 3: {
                            IPackageFragmentRoot fragmentRoot = (IPackageFragmentRoot)element;
                            IApiComponent apiComponent = workspaceBaseline.getApiComponent(javaProject.getElementName());
                            if (apiComponent != null) {
                                CompareOperation.addElementFor(fragmentRoot, apiComponent, scope);
                            }
                            break;
                        }
                        case 2: {
                            IApiComponent apiComponent = workspaceBaseline.getApiComponent(javaProject.getElementName());
                            if (apiComponent != null) {
                                scope.addElement((IApiElement)apiComponent);
                            }
                            break;
                        }
                    }
                }
                catch (CoreException e) {
                    ApiPlugin.log((Throwable)e);
                }
            }
            ++i;
        }
        return scope;
    }

    private static void addElementFor(IPackageFragmentRoot fragmentRoot, IApiComponent apiComponent, ApiScope scope) throws JavaModelException, CoreException {
        IJavaElement[] packageFragments;
        boolean isArchive = fragmentRoot.isArchive();
        IJavaElement[] iJavaElementArray = packageFragments = fragmentRoot.getChildren();
        int n = packageFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement javaPackageFragment = iJavaElementArray[n2];
            IPackageFragment packageFragment = (IPackageFragment)javaPackageFragment;
            CompareOperation.addElementFor(packageFragment, isArchive, apiComponent, scope);
            ++n2;
        }
    }

    private static void addElementFor(IPackageFragment packageFragment, boolean isArchive, IApiComponent apiComponent, ApiScope scope) throws JavaModelException, CoreException {
        IApiDescription apiDescription = apiComponent.getApiDescription();
        IApiAnnotations annotations = apiDescription.resolveAnnotations((IElementDescriptor)Factory.packageDescriptor((String)packageFragment.getElementName()));
        if (annotations == null || !VisibilityModifiers.isAPI((int)annotations.getVisibility())) {
            return;
        }
        if (isArchive) {
            IOrdinaryClassFile[] classFiles;
            IOrdinaryClassFile[] iOrdinaryClassFileArray = classFiles = packageFragment.getOrdinaryClassFiles();
            int n = classFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IOrdinaryClassFile classFile = iOrdinaryClassFileArray[n2];
                CompareOperation.addElementFor(classFile, apiComponent, scope);
                ++n2;
            }
        } else {
            ICompilationUnit[] units;
            ICompilationUnit[] iCompilationUnitArray = units = packageFragment.getCompilationUnits();
            int n = units.length;
            int n3 = 0;
            while (n3 < n) {
                ICompilationUnit unit = iCompilationUnitArray[n3];
                CompareOperation.addElementFor(unit, apiComponent, scope);
                ++n3;
            }
        }
    }

    private static void addElementFor(IOrdinaryClassFile classFile, IApiComponent apiComponent, ApiScope scope) {
        try {
            IApiTypeRoot typeRoot = apiComponent.findTypeRoot(classFile.getType().getFullyQualifiedName());
            if (typeRoot != null) {
                scope.addElement((IApiElement)typeRoot);
            }
        }
        catch (CoreException e) {
            ApiPlugin.log((Throwable)e);
        }
    }

    private static void addElementFor(ICompilationUnit compilationUnit, IApiComponent component, ApiScope scope) throws JavaModelException {
        IType[] types;
        IType[] iTypeArray = types = compilationUnit.getTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                IApiTypeRoot typeRoot = component.findTypeRoot(type.getFullyQualifiedName());
                if (typeRoot != null) {
                    scope.addElement((IApiElement)typeRoot);
                }
            }
            catch (CoreException e) {
                ApiPlugin.log((Throwable)e);
            }
            ++n2;
        }
    }
}

