/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.function.Supplier;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.RoundingMode;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.version.OsVersion;
import org.eclipse.swt.widgets.Display;

public class Win32DPIUtils {
    private static final String SWT_AUTOSCALE_UPDATE_ON_RUNTIME = "swt.autoScale.updateOnRuntime";

    static {
        DPIUtil.setUseSmoothScalingByDefaultProvider(() -> Win32DPIUtils.isMonitorSpecificScalingActive());
    }

    public static boolean setDPIAwareness(int desiredDpiAwareness) {
        boolean perMonitorV2Available;
        if ((long)desiredDpiAwareness == OS.GetThreadDpiAwarenessContext()) {
            return true;
        }
        if (desiredDpiAwareness == 34 && !(perMonitorV2Available = OsVersion.IS_WIN10_1809)) {
            System.err.println("***WARNING: the OS version does not support DPI awareness mode PerMonitorV2.");
            return false;
        }
        long setDpiAwarenessResult = OS.SetThreadDpiAwarenessContext(desiredDpiAwareness);
        if (setDpiAwarenessResult == 0L) {
            System.err.println("***WARNING: setting DPI awareness failed.");
            return false;
        }
        return true;
    }

    public static <T> T runWithProperDPIAwareness(Display display, Supplier<T> operation) {
        if (!display.isRescalingAtRuntime()) {
            return operation.get();
        }
        long previousDPIAwareness = OS.GetThreadDpiAwarenessContext();
        try {
            if (!Win32DPIUtils.setDPIAwareness(34)) {
                previousDPIAwareness = 0L;
            }
            T t = operation.get();
            return t;
        }
        finally {
            if (previousDPIAwareness > 0L) {
                OS.SetThreadDpiAwarenessContext(previousDPIAwareness);
            }
        }
    }

    public static float[] pixelToPoint(float[] size, int zoom) {
        if (zoom == 100 || size == null) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        float[] scaledSize = new float[size.length];
        int i = 0;
        while (i < scaledSize.length) {
            scaledSize[i] = size[i] / scaleFactor;
            ++i;
        }
        return scaledSize;
    }

    public static float[] pixelToPoint(Drawable drawable, float[] size, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return Win32DPIUtils.pixelToPoint(size, zoom);
    }

    public static int pixelToPoint(Drawable drawable, int size, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return DPIUtil.pixelToPoint(size, zoom);
    }

    public static float pixelToPoint(Drawable drawable, float size, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return DPIUtil.pixelToPoint(size, zoom);
    }

    public static Point pixelToPointAsSize(Drawable drawable, Point point, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return point;
        }
        return Win32DPIUtils.pixelToPointAsSize(point, zoom);
    }

    public static Point pixelToPointAsLocation(Drawable drawable, Point point, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return point;
        }
        return Win32DPIUtils.pixelToPointAsLocation(point, zoom);
    }

    public static Point pixelToPointAsSize(Point point, int zoom) {
        return Win32DPIUtils.pixelToPoint(point, zoom, RoundingMode.UP);
    }

    public static Point pixelToPointAsLocation(Point point, int zoom) {
        return Win32DPIUtils.pixelToPoint(point, zoom, RoundingMode.ROUND);
    }

    private static Point pixelToPoint(Point point, int zoom, RoundingMode mode) {
        if (zoom == 100 || point == null) {
            return point;
        }
        Point.OfFloat fPoint = Point.OfFloat.from(point);
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        float scaledX = fPoint.getX() / scaleFactor;
        float scaledY = fPoint.getY() / scaleFactor;
        return new Point.OfFloat(scaledX, scaledY, mode);
    }

    public static Rectangle pixelToPoint(Rectangle rect, int zoom) {
        if (zoom == 100 || rect == null) {
            return rect;
        }
        if (rect instanceof Rectangle.OfFloat) {
            Rectangle.OfFloat rectOfFloat = (Rectangle.OfFloat)rect;
            return Win32DPIUtils.pixelToPoint(rectOfFloat, zoom);
        }
        Rectangle.OfFloat scaledRect = new Rectangle.OfFloat(0, 0, 0, 0);
        Point scaledTopLeft = Win32DPIUtils.pixelToPointAsLocation(new Point(rect.x, rect.y), zoom);
        Point scaledBottomRight = Win32DPIUtils.pixelToPointAsLocation(new Point(rect.x + rect.width, rect.y + rect.height), zoom);
        scaledRect.x = scaledTopLeft.x;
        scaledRect.y = scaledTopLeft.y;
        scaledRect.width = scaledBottomRight.x - scaledTopLeft.x;
        scaledRect.height = scaledBottomRight.y - scaledTopLeft.y;
        return scaledRect;
    }

    private static Rectangle pixelToPoint(Rectangle.OfFloat rect, int zoom) {
        return Win32DPIUtils.scaleBounds(rect, 100, zoom);
    }

    public static Rectangle pixelToPoint(Drawable drawable, Rectangle rect, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return rect;
        }
        return Win32DPIUtils.pixelToPoint(rect, zoom);
    }

    public static Rectangle scaleBounds(Rectangle rect, int targetZoom, int currentZoom) {
        if (rect == null || targetZoom == currentZoom) {
            return rect;
        }
        if (rect instanceof Rectangle.OfFloat) {
            Rectangle.OfFloat rectOfFloat = (Rectangle.OfFloat)rect;
            return Win32DPIUtils.scaleBounds(rectOfFloat, targetZoom, currentZoom);
        }
        float scaleFactor = (float)targetZoom / (float)currentZoom;
        Rectangle.OfFloat returnRect = new Rectangle.OfFloat(0, 0, 0, 0);
        returnRect.x = Math.round((float)rect.x * scaleFactor);
        returnRect.y = Math.round((float)rect.y * scaleFactor);
        returnRect.width = Math.round((float)rect.width * scaleFactor);
        returnRect.height = Math.round((float)rect.height * scaleFactor);
        return returnRect;
    }

    private static Rectangle scaleBounds(Rectangle.OfFloat rect, int targetZoom, int currentZoom) {
        if (rect == null || targetZoom == currentZoom) {
            return rect;
        }
        Rectangle.OfFloat fRect = Rectangle.OfFloat.from(rect);
        float scaleFactor = DPIUtil.getScalingFactor(targetZoom, currentZoom);
        float scaledX = fRect.getX() * scaleFactor;
        float scaledY = fRect.getY() * scaleFactor;
        float scaledWidth = fRect.getWidth() * scaleFactor;
        float scaledHeight = fRect.getHeight() * scaleFactor;
        return new Rectangle.OfFloat(scaledX, scaledY, scaledWidth, scaledHeight);
    }

    public static int[] pointToPixel(int[] pointArray, int zoom) {
        if (zoom == 100 || pointArray == null) {
            return pointArray;
        }
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        int[] returnArray = new int[pointArray.length];
        int i = 0;
        while (i < pointArray.length) {
            returnArray[i] = Math.round((float)pointArray[i] * scaleFactor);
            ++i;
        }
        return returnArray;
    }

    public static int[] pointToPixel(Drawable drawable, int[] pointArray, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return pointArray;
        }
        return Win32DPIUtils.pointToPixel(pointArray, zoom);
    }

    public static int pointToPixel(Drawable drawable, int size, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return DPIUtil.pointToPixel(size, zoom);
    }

    public static float pointToPixel(float size, int zoom) {
        if (zoom == 100 || size == -1.0f) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        return size * scaleFactor;
    }

    public static float pointToPixel(Drawable drawable, float size, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return Win32DPIUtils.pointToPixel(size, zoom);
    }

    private static Point pointToPixel(Point point, int zoom, RoundingMode mode) {
        if (zoom == 100 || point == null) {
            return point;
        }
        Point.OfFloat fPoint = Point.OfFloat.from(point);
        float scaleFactor = DPIUtil.getScalingFactor(zoom);
        float scaledX = fPoint.getX() * scaleFactor;
        float scaledY = fPoint.getY() * scaleFactor;
        return new Point.OfFloat(scaledX, scaledY, mode);
    }

    public static Point pointToPixelAsSize(Drawable drawable, Point point, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return point;
        }
        return Win32DPIUtils.pointToPixelAsSize(point, zoom);
    }

    public static Point pointToPixelAsLocation(Drawable drawable, Point point, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return point;
        }
        return Win32DPIUtils.pointToPixelAsLocation(point, zoom);
    }

    public static Point pointToPixelAsSize(Point point, int zoom) {
        return Win32DPIUtils.pointToPixel(point, zoom, RoundingMode.UP);
    }

    public static Point pointToPixelAsLocation(Point point, int zoom) {
        return Win32DPIUtils.pointToPixel(point, zoom, RoundingMode.ROUND);
    }

    public static Rectangle pointToPixel(Rectangle rect, int zoom) {
        if (zoom == 100 || rect == null) {
            return rect;
        }
        if (rect instanceof Rectangle.OfFloat) {
            Rectangle.OfFloat rectOfFloat = (Rectangle.OfFloat)rect;
            return Win32DPIUtils.pointToPixel(rectOfFloat, zoom);
        }
        Rectangle.OfFloat scaledRect = new Rectangle.OfFloat(0, 0, 0, 0);
        Point scaledTopLeft = Win32DPIUtils.pointToPixelAsLocation(new Point(rect.x, rect.y), zoom);
        Point scaledBottomRight = Win32DPIUtils.pointToPixelAsLocation(new Point(rect.x + rect.width, rect.y + rect.height), zoom);
        scaledRect.x = scaledTopLeft.x;
        scaledRect.y = scaledTopLeft.y;
        scaledRect.width = scaledBottomRight.x - scaledTopLeft.x;
        scaledRect.height = scaledBottomRight.y - scaledTopLeft.y;
        return scaledRect;
    }

    private static Rectangle pointToPixel(Rectangle.OfFloat rect, int zoom) {
        return Win32DPIUtils.scaleBounds(rect, zoom, 100);
    }

    public static Rectangle pointToPixel(Drawable drawable, Rectangle rect, int zoom) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return rect;
        }
        return Win32DPIUtils.pointToPixel(rect, zoom);
    }

    public static void setMonitorSpecificScaling(boolean activate) {
        System.setProperty(SWT_AUTOSCALE_UPDATE_ON_RUNTIME, Boolean.toString(activate));
    }

    public static void setAutoScaleForMonitorSpecificScaling() {
        boolean isDefaultAutoScale;
        boolean bl = isDefaultAutoScale = DPIUtil.getAutoScaleValue() == null;
        if (isDefaultAutoScale) {
            DPIUtil.setAutoScaleValue("quarter");
        } else if (!Win32DPIUtils.isSupportedAutoScaleForMonitorSpecificScaling()) {
            throw new SWTError(20, "monitor-specific scaling is only implemented for auto-scale values \"quarter\", \"exact\", \"false\" or a concrete zoom value, but \"" + DPIUtil.getAutoScaleValue() + "\" has been specified");
        }
    }

    private static boolean isSupportedAutoScaleForMonitorSpecificScaling() {
        if (DPIUtil.getAutoScaleValue() == null) {
            return false;
        }
        switch (DPIUtil.getAutoScaleValue().toLowerCase()) {
            case "exact": 
            case "false": 
            case "quarter": {
                return true;
            }
        }
        try {
            Integer.parseInt(DPIUtil.getAutoScaleValue());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isMonitorSpecificScalingActive() {
        boolean updateOnRuntimeValue = Boolean.getBoolean(SWT_AUTOSCALE_UPDATE_ON_RUNTIME);
        return updateOnRuntimeValue;
    }

    public static int getPrimaryMonitorZoomAtStartup() {
        long hDC = OS.GetDC(0L);
        int dpi = OS.GetDeviceCaps(hDC, 88);
        OS.ReleaseDC(0L, hDC);
        return DPIUtil.mapDPIToZoom(dpi);
    }

    public static final class AutoScaleImageDataProvider
    implements ImageDataProvider {
        Device device;
        ImageData imageData;
        int currentZoom;

        public AutoScaleImageDataProvider(Device device, ImageData data, int zoom) {
            this.device = device;
            this.imageData = data;
            this.currentZoom = zoom;
        }

        @Override
        public ImageData getImageData(int zoom) {
            return DPIUtil.scaleImageData(this.device, this.imageData, zoom, this.currentZoom);
        }
    }
}

