/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer.impl;

import com.github.weisj.jsvg.paint.SVGPaint;
import com.github.weisj.jsvg.paint.impl.PredefinedPaints;
import com.github.weisj.jsvg.renderer.impl.context.ContextElementAttributes;
import com.github.weisj.jsvg.renderer.impl.context.PaintContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PaintResolver {
    private PaintResolver() {
    }

    @NotNull
    public static SVGPaint resolvePaint(@Nullable SVGPaint p, @NotNull PaintContext paintContext, @Nullable ContextElementAttributes contextElementAttributes) {
        if (p == PredefinedPaints.DEFAULT_PAINT || p == PredefinedPaints.CURRENT_COLOR) {
            return PaintResolver.coerceNonNull(paintContext.color);
        }
        if (p == PredefinedPaints.CONTEXT_STROKE) {
            if (contextElementAttributes == null) {
                return PredefinedPaints.NONE;
            }
            return contextElementAttributes.strokePaint;
        }
        if (p == PredefinedPaints.CONTEXT_FILL) {
            if (contextElementAttributes == null) {
                return PredefinedPaints.NONE;
            }
            return contextElementAttributes.fillPaint;
        }
        return PaintResolver.coerceNonNull(p);
    }

    @NotNull
    private static SVGPaint coerceNonNull(@Nullable SVGPaint p) {
        return p != null ? p : PredefinedPaints.DEFAULT_PAINT;
    }
}

