/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.ui.OomphDragAdapter;
import org.eclipse.oomph.internal.ui.OomphEditingDomain;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public final class GeneralDragAdapter
extends OomphDragAdapter {
    private CopyAction copyAction;
    private MenuManager contextMenu;

    public GeneralDragAdapter(Viewer viewer, DraggedObjectsFactory factory, List<? extends OomphTransferDelegate> delegates) {
        super(GeneralDragAdapter.createEditingDomain(delegates), GeneralDragAdapter.createSelectionProvider(viewer, factory), delegates);
        this.createContextMenu(viewer.getControl());
    }

    public EditingDomain getEditingDomain() {
        return this.domain;
    }

    public CopyAction getCopyAction() {
        return this.copyAction;
    }

    public MenuManager getContextMenu() {
        return this.contextMenu;
    }

    private void createContextMenu(Control control) {
        this.copyAction = new CopyAction(this.domain);
        this.copyAction.setId(ActionFactory.COPY.getId());
        try {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        }
        catch (RuntimeException sharedImages) {
            // empty catch block
        }
        this.contextMenu = new MenuManager("#PopUp");
        this.contextMenu.add((IContributionItem)new Separator("additions"));
        this.contextMenu.setRemoveAllWhenShown(true);
        this.contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)GeneralDragAdapter.this.selectionProvider.getSelection();
                GeneralDragAdapter.this.copyAction.setEnabled(GeneralDragAdapter.this.copyAction.updateSelection(selection));
                if (GeneralDragAdapter.this.copyAction.isEnabled()) {
                    manager.add((IAction)GeneralDragAdapter.this.copyAction);
                }
            }
        });
        Menu menu = this.contextMenu.createContextMenu(control);
        control.setMenu(menu);
    }

    private static EditingDomain createEditingDomain(List<? extends OomphTransferDelegate> delegates) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        OomphEditingDomain editingDomain = new OomphEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack(), new HashMap<Resource, Boolean>(), delegates);
        return editingDomain;
    }

    private static ISelectionProvider createSelectionProvider(final Viewer viewer, final DraggedObjectsFactory factory) {
        return new ISelectionProvider(){

            public ISelection getSelection() {
                ISelection selection = viewer.getSelection();
                try {
                    List<Object> objects = factory.createDraggedObjects(selection);
                    if (objects != null && !objects.isEmpty()) {
                        return new StructuredSelection(objects);
                    }
                }
                catch (Exception ex) {
                    UIPlugin.INSTANCE.log(ex);
                }
                return StructuredSelection.EMPTY;
            }

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }
        };
    }

    public static interface DraggedObjectsFactory {
        public List<Object> createDraggedObjects(ISelection var1) throws Exception;
    }
}

