/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors;

import java.io.IOException;
import java.util.Collection;
import lpg.runtime.IToken;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.CompletionProposalUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionProposal;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors.AbstractMetamodelCollector;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors.Messages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.WorkspaceMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MModelURIMapFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MModelURIMapPackage;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MappingContainer;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MetamodelURIMappingHelper;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.URIMapping;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceMetamodelCollector
extends AbstractMetamodelCollector {
    @Override
    public void addPropoposals(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        IMetamodelDesc[] workspaceMetamodels;
        IMetamodelDesc[] iMetamodelDescArray = workspaceMetamodels = new WorkspaceMetamodelProvider().getMetamodels();
        int n = workspaceMetamodels.length;
        int n2 = 0;
        while (n2 < n) {
            IMetamodelDesc workspaceMetamodel = iMetamodelDescArray[n2];
            QvtCompletionProposal proposal = WorkspaceMetamodelCollector.createCompletionProposal(Path.fromPortableString((String)workspaceMetamodel.getId()), data);
            proposals.add(proposal);
            ++n2;
        }
    }

    public static final QvtCompletionProposal createCompletionProposal(final IPath workspaceMetamodelPath, final QvtCompletionData data) {
        IToken currentToken = data.getCurrentToken();
        int offset = data.getOffset();
        int replacementOffset = currentToken == null ? offset : currentToken.getStartOffset();
        int replacementLength = offset - replacementOffset;
        String displayString = workspaceMetamodelPath.toString();
        Image image = CompletionProposalUtil.getImage("cat-package");
        return new QvtCompletionProposal(null, replacementOffset, replacementLength, -1, image, displayString, null, null){

            public void apply(IDocument document) {
                URI resURI = URI.createPlatformResourceURI((String)workspaceMetamodelPath.toString(), (boolean)false);
                EPackage pack = WorkspaceMetamodelCollector.loadPackage(resURI);
                if (pack == null) {
                    data.showError(NLS.bind((String)Messages.WorkspaceMetamodelCollector_EPackageLoadError, (Object)workspaceMetamodelPath));
                } else if (pack.getName() == null || pack.getNsURI() == null) {
                    data.showError(NLS.bind((String)Messages.WorkspaceMetamodelCollector_EPackageNameOrNsUriIsNull, (Object)workspaceMetamodelPath));
                } else {
                    WorkspaceMetamodelCollector.addToSettings(data, resURI, pack);
                    String replacementString = WorkspaceMetamodelCollector.getProposalString(data, pack);
                    this.setReplacementString(replacementString);
                    this.setCursorPosition(replacementString.length());
                    super.apply(document);
                }
            }
        };
    }

    private static EPackage loadPackage(URI uri) {
        Resource res = EmfUtil.loadResource((URI)uri);
        return EmfUtil.getFirstEPackageContent((Resource)res);
    }

    private static void addToSettings(QvtCompletionData data, URI resURI, EPackage pack) {
        IProject project;
        URI cFile = data.getCFile().getURI();
        if (!cFile.isPlatformResource()) {
            return;
        }
        String wsRelativePath = cFile.toPlatformString(true);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(wsRelativePath));
        if (resource != null && (project = resource.getProject()) != null) {
            MappingContainer uriMap = WorkspaceMetamodelCollector.loadMappings(project);
            URIMapping mapping = WorkspaceMetamodelCollector.createMapping(resURI, pack);
            WorkspaceMetamodelCollector.removeOldMapping(uriMap, mapping);
            uriMap.getMapping().add((Object)mapping);
            WorkspaceMetamodelCollector.saveMappings(uriMap, project);
        }
    }

    private static URIMapping createMapping(URI resURI, EPackage pack) {
        URIMapping mapping = MModelURIMapFactory.eINSTANCE.createURIMapping();
        mapping.setSourceURI(pack.getNsURI());
        mapping.setTargetURI(resURI.toString());
        return mapping;
    }

    private static void removeOldMapping(MappingContainer uriMap, URIMapping pattern) {
        for (URIMapping mapping : uriMap.getMapping()) {
            if (!pattern.getSourceURI().equals(mapping.getSourceURI()) && !pattern.getTargetURI().equals(mapping.getTargetURI())) continue;
            uriMap.getMapping().remove((Object)mapping);
            break;
        }
    }

    private static MappingContainer loadMappings(IProject project) {
        MModelURIMapPackage.eINSTANCE.getNsURI();
        Resource res = MetamodelURIMappingHelper.createMappingResource((IProject)project);
        try {
            if (MetamodelURIMappingHelper.hasMappingResource((IProject)project)) {
                res.load(null);
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
        return res.getContents().isEmpty() ? MetamodelURIMappingHelper.createNewMappings((Resource)res) : MetamodelURIMappingHelper.getMappings((Resource)res);
    }

    private static void saveMappings(MappingContainer uriMap, IProject project) {
        Resource res = uriMap.eResource();
        try {
            res.save(null);
        }
        catch (IOException e) {
            Activator.log(e);
        }
        if (project != null) {
            try {
                IFile mappingFile = MetamodelURIMappingHelper.getMappingFileHandle((IProject)project);
                mappingFile.refreshLocal(0, null);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
    }
}

