/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.cst.adapters.ModelTypeMetamodelsAdapter;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.types.InvalidType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.types.VoidType;

public class QvtOperationalUtil {
    private static final Object ourOclInvalid = new QvtOperationalEnvFactory().createEnvironment(null).getOCLStandardLibrary().getOclInvalid();
    private static final EClassifier ourOclVoid = (EClassifier)new QvtOperationalEnvFactory().createEnvironment(null).getOCLStandardLibrary().getOclVoid();

    private QvtOperationalUtil() {
    }

    public static String getStringRepresentation(PathNameCS pathName, String pathSeparator) {
        return QvtOperationalParserUtil.getStringRepresentation(pathName, pathSeparator);
    }

    public static String getStringRepresentation(TypeCS typeCS) {
        return QvtOperationalParserUtil.getStringRepresentation(typeCS);
    }

    public static boolean isAssignableToFrom(QvtOperationalEnv env, EClassifier to, EClassifier from) {
        return QvtOperationalParserUtil.isAssignableToFrom(env, to, from);
    }

    public static boolean isUndefined(Object value) {
        return value == null || value == QvtOperationalUtil.getOclInvalid();
    }

    public static boolean isCreateFromStringSupported(EClassifier type) {
        return QvtOperationalUtil.isPrimitiveType(type) || type instanceof EDataType;
    }

    public static Object getOclInvalid() {
        return ourOclInvalid;
    }

    public static EClassifier getOclVoid() {
        return ourOclVoid;
    }

    public static boolean isPrimitiveType(Object type) {
        return type instanceof PrimitiveType;
    }

    public static boolean isInstantiable(EClass cls) {
        return !cls.isAbstract() && !cls.isInterface();
    }

    public static boolean isMappingOperation(EOperation operation) {
        EAnnotation ann;
        if (operation instanceof MappingOperation) {
            return true;
        }
        EAnnotation eAnnotation = ann = operation != null ? operation.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL") : null;
        if (ann != null && !ann.getContents().isEmpty()) {
            for (EObject o : ann.getContents()) {
                if (!(o instanceof Constraint) || !"mapping_operation".equals(((Constraint)o).getStereotype())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isImperativeOperation(EOperation operation) {
        if (operation instanceof ImperativeOperation) {
            return true;
        }
        EAnnotation ann = operation.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
        if (ann != null && !ann.getContents().isEmpty()) {
            for (EObject o : ann.getContents()) {
                if (!(o instanceof Constraint) || !"mapping_operation".equals(((Constraint)o).getStereotype()) && !"imperative_operation".equals(((Constraint)o).getStereotype())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isModelParamEqual(ModelParameter param, ModelParameter importedParam, boolean isStrictCompare) {
        if (param.getKind() == DirectionKind.IN && importedParam.getKind() != DirectionKind.IN) {
            return false;
        }
        if (!isStrictCompare) {
            return true;
        }
        return ModelTypeMetamodelsAdapter.getMetamodels((EObject)param.getEType()).equals(ModelTypeMetamodelsAdapter.getMetamodels((EObject)importedParam.getEType()));
    }

    public static final Boolean oclIsKindOf(Object value, EClassifier type, QvtOperationalEvaluationEnv env) {
        if (type == null) {
            return null;
        }
        if (QvtOperationalUtil.isUndefined(value)) {
            return QvtOperationalUtil.oclIsTypeOf(value, type, env);
        }
        return env.isKindOf(value, type);
    }

    public static final Boolean oclIsTypeOf(Object value, EClassifier type, QvtOperationalEvaluationEnv env) {
        if (type == null) {
            return null;
        }
        if (value == null) {
            return type instanceof VoidType;
        }
        if (value == QvtOperationalUtil.getOclInvalid()) {
            return type instanceof InvalidType;
        }
        return env.isTypeOf(value, type);
    }

    public static boolean isAbstract(EClassifier eClassifier) {
        if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            return eClass.isAbstract() || eClass.isInterface();
        }
        return false;
    }

    public static boolean hasAbstractOutputParamerter(ImperativeOperation operation) {
        for (VarParameter nextParam : operation.getResult()) {
            if (nextParam.getEType() == null || !QvtOperationalUtil.isAbstract(nextParam.getEType())) continue;
            return true;
        }
        for (EParameter eParam : operation.getEParameters()) {
            VarParameter varParam;
            if (!(eParam instanceof VarParameter) || (varParam = (VarParameter)eParam).getEType() == null || !QvtOperationalUtil.isAbstract(varParam.getEType())) continue;
            return true;
        }
        return false;
    }
}

