/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.InheritanceAnalysis;

public class ContainmentAnalysis {
    private static final @NonNull List<@NonNull CompleteClass> EMPTY_CLASS_LIST = Collections.emptyList();
    private static final @NonNull List<@NonNull Property> EMPTY_PROPERTY_LIST = Collections.emptyList();
    protected final @NonNull CompleteModel completeModel;
    protected final @NonNull InheritanceAnalysis inheritanceAnalysis;
    private final @NonNull Map<@NonNull CompleteClass, @NonNull List<@NonNull Property>> containedClass2containmentProperties = new HashMap<CompleteClass, List<Property>>();
    private final @NonNull Map<@NonNull CompleteClass, @NonNull List<@NonNull CompleteClass>> containedClass2containerClasses = new HashMap<CompleteClass, List<CompleteClass>>();

    public ContainmentAnalysis(@NonNull EnvironmentFactory environmentFactory) {
        this.completeModel = environmentFactory.getCompleteModel();
        this.inheritanceAnalysis = new InheritanceAnalysis(environmentFactory);
        for (CompleteClass completeClass : this.inheritanceAnalysis.getAllCompleteClasses()) {
            this.computeContainedClass2ContainerClasses(completeClass);
        }
    }

    private void addContainmentForContainedClasses(@NonNull CompleteClass containerClass, @NonNull Property containmentProperty, @NonNull CompleteClass containedClass) {
        List<CompleteClass> containerClasses;
        List<@NonNull Property> containmentProperties = this.containedClass2containmentProperties.get(containedClass);
        if (containmentProperties == null) {
            containmentProperties = new ArrayList<Property>();
            this.containedClass2containmentProperties.put(containedClass, containmentProperties);
        }
        if (!containmentProperties.contains(containmentProperty)) {
            containmentProperties.add(containmentProperty);
        }
        if ((containerClasses = this.containedClass2containerClasses.get(containedClass)) == null) {
            containerClasses = new ArrayList<CompleteClass>();
            this.containedClass2containerClasses.put(containedClass, containerClasses);
        }
        if (!containerClasses.contains(containerClass)) {
            containerClasses.add(containerClass);
        }
    }

    private void computeContainedClass2ContainerClasses(@NonNull CompleteClass containerCompleteClass) {
        for (Property property : containerCompleteClass.getProperties(FeatureFilter.SELECT_NON_STATIC)) {
            if (!property.isIsComposite()) continue;
            Type type = property.getType();
            if (type instanceof CollectionType) {
                type = ((CollectionType)type).getElementType();
            }
            assert (type != null);
            CompleteClass containedCompleteClass = this.completeModel.getCompleteClass(type);
            for (CompleteClass containedSubCompleteClass : this.inheritanceAnalysis.getAllSuperAndSelfAndSubClasses(containedCompleteClass)) {
                this.addContainmentForContainedClasses(containerCompleteClass, property, containedSubCompleteClass);
            }
        }
    }

    public @NonNull Iterable<@NonNull CompleteClass> getContainerClasses(@NonNull CompleteClass containedClass) {
        List<@NonNull CompleteClass> containerClasses = this.containedClass2containerClasses.get(containedClass);
        return containerClasses == null ? EMPTY_CLASS_LIST : containerClasses;
    }

    public @NonNull Iterable<@NonNull Property> getContainmentProperties(@NonNull CompleteClass containedClass) {
        List<@NonNull Property> containmentProperties = this.containedClass2containmentProperties.get(containedClass);
        return containmentProperties == null ? EMPTY_PROPERTY_LIST : containmentProperties;
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.inheritanceAnalysis.getEnvironmentFactory();
    }

    public @NonNull InheritanceAnalysis getInheritanceAnalysis() {
        return this.inheritanceAnalysis;
    }
}

