/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.pages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.qvtd.debug.ui.QVTdDebugUIPlugin;
import org.eclipse.qvtd.debug.ui.messages.DebugUIMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class QVTiBreakpointPage
extends PropertyPage {
    protected Button fEnabledButton;
    protected Button fHitCountButton;
    protected Text fHitCountText;
    protected Combo fSuspendPolicy;
    protected List<String> fErrorMessages = new ArrayList<String>();
    public static final String ATTR_DELETE_ON_CANCEL = "org.eclipse.qvtd.debug.ui.ATTR_DELETE_ON_CANCEL";
    protected static final String EMPTY_STRING = "";
    private static final String fgHitCountErrorMessage = DebugUIMessages.QVTiBreakpointPage_HitCountErrorMessage;

    public boolean performOk() {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                boolean delOnCancel;
                VMLineBreakpoint breakpoint = QVTiBreakpointPage.this.getBreakpoint();
                boolean bl = delOnCancel = breakpoint.getMarker().getAttribute(QVTiBreakpointPage.ATTR_DELETE_ON_CANCEL) != null;
                if (delOnCancel) {
                    breakpoint.getMarker().setAttribute(QVTiBreakpointPage.ATTR_DELETE_ON_CANCEL, null);
                    breakpoint.setRegistered(true);
                }
                QVTiBreakpointPage.this.doStore();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null, 0, null);
        }
        catch (CoreException e) {
            QVTdDebugUIPlugin.statusDialog(e.getStatus());
            QVTdDebugUIPlugin.log(e);
        }
        return super.performOk();
    }

    protected void addErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        this.fErrorMessages.add(message);
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    protected void removeErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        if (this.fErrorMessages.isEmpty()) {
            this.addErrorMessage(null);
        } else {
            this.addErrorMessage(this.fErrorMessages.get(this.fErrorMessages.size() - 1));
        }
    }

    protected void doStore() throws CoreException {
        VMLineBreakpoint breakpoint = this.getBreakpoint();
        this.storeHitCount(breakpoint);
        this.storeEnabled(breakpoint);
    }

    private void storeEnabled(VMLineBreakpoint breakpoint) throws CoreException {
        breakpoint.setEnabled(this.fEnabledButton.getSelection());
    }

    private void storeHitCount(VMLineBreakpoint breakpoint) throws CoreException {
        int hitCount = -1;
        if (this.fHitCountButton.getSelection()) {
            try {
                hitCount = Integer.parseInt(this.fHitCountText.getText());
            }
            catch (NumberFormatException e) {
                QVTdDebugUIPlugin.log((IStatus)new Status(4, "org.eclipse.qvtd.debug.ui", 4, MessageFormat.format("JavaBreakpointPage allowed input of invalid string for hit count value: {0}.", this.fHitCountText.getText()), (Throwable)e));
            }
        }
        breakpoint.setHitCount(hitCount);
    }

    protected Control createContents(Composite parent) {
        this.setTitle(DebugUIMessages.QVTiBreakpointPage_ModulePrepareBreakpoint);
        this.noDefaultAndApplyButton();
        Composite mainComposite = this.createComposite(parent, 1);
        try {
            this.createLabels(mainComposite);
            this.createEnabledButton(mainComposite);
            this.createHitCountEditor(mainComposite);
            this.createTypeSpecificEditors(mainComposite);
        }
        catch (CoreException e) {
            QVTdDebugUIPlugin.log(e);
        }
        this.setValid(true);
        try {
            if (this.getBreakpoint().getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null) {
                this.getShell().addShellListener(new ShellListener(){

                    public void shellActivated(ShellEvent e) {
                        Shell shell = (Shell)e.getSource();
                        shell.setText(MessageFormat.format(DebugUIMessages.QVTiBreakpointPage_CreateBreakpointForModule, QVTiBreakpointPage.this.getName((IAdaptable)QVTiBreakpointPage.this.getBreakpoint())));
                        shell.removeShellListener((ShellListener)this);
                    }

                    public void shellClosed(ShellEvent e) {
                    }

                    public void shellDeactivated(ShellEvent e) {
                    }

                    public void shellDeiconified(ShellEvent e) {
                    }

                    public void shellIconified(ShellEvent e) {
                    }
                });
            }
        }
        catch (CoreException e) {
            QVTdDebugUIPlugin.log(e);
        }
        return mainComposite;
    }

    private String getName(IAdaptable element) {
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)element.getAdapter(IWorkbenchAdapter.class);
        if (adapter != null) {
            return adapter.getLabel((Object)element);
        }
        return EMPTY_STRING;
    }

    protected void createLabels(Composite parent) throws CoreException {
        Composite labelComposite = this.createComposite(parent, 2);
        String typeName = this.getBreakpoint().getUnitURI().toPlatformString(true);
        if (typeName != null) {
            this.createLabel(labelComposite, DebugUIMessages.QVTiBreakpointPage_Module);
            Text text = SWTFactory.createText((Composite)labelComposite, (int)8, (int)1, (String)typeName);
            text.setBackground(parent.getBackground());
        }
        this.createTypeSpecificLabels(labelComposite);
    }

    private void createHitCountEditor(Composite parent) throws CoreException {
        Composite hitCountComposite = this.createComposite(parent, 2);
        this.fHitCountButton = this.createCheckButton(hitCountComposite, DebugUIMessages.QVTiBreakpointPage_HitCount);
        this.fHitCountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                QVTiBreakpointPage.this.fHitCountText.setEnabled(QVTiBreakpointPage.this.fHitCountButton.getSelection());
                QVTiBreakpointPage.this.hitCountChanged();
            }
        });
        int hitCount = this.getBreakpoint().getHitCount();
        String hitCountString = EMPTY_STRING;
        if (hitCount > 0) {
            hitCountString = new Integer(hitCount).toString();
            this.fHitCountButton.setSelection(true);
        } else {
            this.fHitCountButton.setSelection(false);
        }
        this.fHitCountText = this.createText(hitCountComposite, hitCountString);
        if (hitCount <= 0) {
            this.fHitCountText.setEnabled(false);
        }
        this.fHitCountText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QVTiBreakpointPage.this.hitCountChanged();
            }
        });
    }

    private void hitCountChanged() {
        if (!this.fHitCountButton.getSelection()) {
            this.removeErrorMessage(fgHitCountErrorMessage);
            return;
        }
        String hitCountText = this.fHitCountText.getText();
        int hitCount = -1;
        try {
            hitCount = Integer.parseInt(hitCountText);
        }
        catch (NumberFormatException e1) {
            this.addErrorMessage(fgHitCountErrorMessage);
            return;
        }
        if (hitCount < 1) {
            this.addErrorMessage(fgHitCountErrorMessage);
        } else {
            this.removeErrorMessage(fgHitCountErrorMessage);
        }
    }

    protected void createEnabledButton(Composite parent) throws CoreException {
        this.fEnabledButton = this.createCheckButton(parent, DebugUIMessages.QVTiBreakpointPage_Enabled);
        this.fEnabledButton.setSelection(this.getBreakpoint().isEnabled());
    }

    protected VMLineBreakpoint getBreakpoint() {
        return (VMLineBreakpoint)this.getElement();
    }

    protected void createTypeSpecificLabels(Composite parent) {
    }

    protected void createTypeSpecificEditors(Composite parent) throws CoreException {
    }

    protected Text createText(Composite parent, String initialValue) {
        return SWTFactory.createText((Composite)parent, (int)2052, (int)1, (String)initialValue);
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        return SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)numColumns, (int)1, (int)768, (int)0, (int)0);
    }

    protected Button createCheckButton(Composite parent, String text) {
        return SWTFactory.createCheckButton((Composite)parent, (String)text, null, (boolean)false, (int)1);
    }

    protected Label createLabel(Composite parent, String text) {
        return SWTFactory.createLabel((Composite)parent, (String)text, (int)1);
    }

    protected Button createRadioButton(Composite parent, String text) {
        return SWTFactory.createRadioButton((Composite)parent, (String)text, (int)1);
    }

    public boolean performCancel() {
        try {
            if (this.getBreakpoint().getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null) {
                this.getBreakpoint().delete();
            }
        }
        catch (CoreException e) {
            QVTdDebugUIPlugin.statusDialog(DebugUIMessages.QVTiBreakpointPage_CancelBreakpointCreationError, e.getStatus());
        }
        return super.performCancel();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }
}

