/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.providers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.AbstractViewProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.IGraphicalTypeRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.service.ProviderServiceUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public abstract class CustomAbstractViewProvider
extends AbstractViewProvider {
    protected IGraphicalTypeRegistry registry;
    protected String diagramType;

    @Override
    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        String graphicalType = this.getEdgeGraphicalType(semanticAdapter, containerView, semanticHint);
        return super.createEdge(semanticAdapter, containerView, graphicalType, index, persisted, preferencesHint);
    }

    @Override
    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        String graphicalType = this.getNodeGraphicalType(semanticAdapter, containerView, semanticHint);
        return super.createNode(semanticAdapter, containerView, graphicalType, index, persisted, preferencesHint);
    }

    @Override
    protected boolean provides(CreateViewForKindOperation op) {
        if (!ProviderServiceUtil.isEnabled(this, op.getContainerView())) {
            return false;
        }
        if (!this.isRelevantDiagram(op.getContainerView().getDiagram())) {
            return false;
        }
        throw new UnsupportedOperationException("Should never be called by the " + this.diagramType + " diagram.");
    }

    @Override
    protected boolean provides(CreateEdgeViewOperation operation) {
        if (!ProviderServiceUtil.isEnabled(this, operation.getContainerView())) {
            return false;
        }
        if (!this.isRelevantDiagram(operation.getContainerView().getDiagram())) {
            return false;
        }
        String graphicalType = this.getEdgeGraphicalType(operation.getSemanticAdapter(), operation.getContainerView(), operation.getSemanticHint());
        return this.getEdgeViewClass(operation.getSemanticAdapter(), operation.getContainerView(), graphicalType) != null;
    }

    @Override
    protected boolean provides(CreateNodeViewOperation operation) {
        if (!ProviderServiceUtil.isEnabled(this, operation.getContainerView())) {
            return false;
        }
        if (!this.isRelevantDiagram(operation.getContainerView().getDiagram())) {
            return false;
        }
        String graphicalType = this.getNodeGraphicalType(operation.getSemanticAdapter(), operation.getContainerView(), operation.getSemanticHint());
        return this.getNodeViewClass(operation.getSemanticAdapter(), operation.getContainerView(), graphicalType) != null;
    }

    protected String getNodeGraphicalType(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        String graphicalType = null;
        if (semanticHint != null && !"".equals(semanticHint)) {
            graphicalType = this.registry.getNodeGraphicalType(semanticHint, containerView.getType());
        } else {
            IElementType elementType;
            EObject domainElement = (EObject)semanticAdapter.getAdapter(EObject.class);
            if (domainElement != null) {
                graphicalType = this.registry.getNodeGraphicalType(domainElement, containerView.getType());
            }
            if ((elementType = (IElementType)semanticAdapter.getAdapter(IElementType.class)) != null) {
                graphicalType = this.registry.getNodeGraphicalType(elementType, containerView.getType());
            }
        }
        return graphicalType;
    }

    protected String getEdgeGraphicalType(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        String graphicalType = null;
        if (semanticHint != null && !"".equals(semanticHint)) {
            graphicalType = this.registry.getEdgeGraphicalType(semanticHint);
        } else {
            IElementType elementType;
            EObject domainElement = (EObject)semanticAdapter.getAdapter(EObject.class);
            if (domainElement != null) {
                graphicalType = this.registry.getEdgeGraphicalType(domainElement);
            }
            if ((elementType = (IElementType)semanticAdapter.getAdapter(IElementType.class)) != null) {
                graphicalType = this.registry.getEdgeGraphicalType(elementType);
            }
        }
        return graphicalType;
    }

    protected boolean isRelevantDiagram(Diagram diagram) {
        ViewPrototype viewPrototype = DiagramUtils.getPrototype(diagram);
        if (viewPrototype != null) {
            return this.diagramType != null && this.diagramType.equals(viewPrototype.getLabel());
        }
        return this.diagramType != null && this.diagramType.equals(diagram.getType());
    }
}

