/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.ast;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xpand2.model.XpandResource;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDefinition
extends SyntaxElement
implements XpandDefinition {
    private static final DeclaredParameter[] NO_PARAM = new DeclaredParameter[0];
    private Template owner = null;
    private final DeclaredParameter[] params;
    private final Identifier name;
    private final Identifier type;
    private final Statement[] body;
    protected String _stringRepresentation = null;
    protected boolean wildParams = false;

    public AbstractDefinition(Identifier name, Identifier type, DeclaredParameter[] params, Statement[] body) {
        this.name = name;
        this.type = type;
        this.params = params != null && params.length > 0 ? params : NO_PARAM;
        this.body = body;
    }

    @Override
    public XpandResource getOwner() {
        return this.owner;
    }

    public void setOwner(Template owner) {
        this.owner = owner;
    }

    @Override
    public DeclaredParameter[] getParams() {
        return this.params;
    }

    public List<DeclaredParameter> getParamsAsList() {
        return Arrays.asList(this.params);
    }

    public Identifier getType() {
        return this.type;
    }

    @Override
    public String getTargetType() {
        return this.type.toString();
    }

    public Identifier getDefName() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public String getQualifiedName() {
        if (this.getFileName() != null) {
            String prefix = this.getFileName().replaceAll("/", "::");
            prefix = prefix.substring(0, prefix.length() - 4);
            return String.valueOf(prefix) + "::" + this.getName();
        }
        return this.getName();
    }

    @Override
    public String getParamString(boolean typesOnly) {
        if (this.params == null || this.params.length == 0) {
            return this.wildParams ? "(*)" : "";
        }
        StringBuilder buff = new StringBuilder("(");
        int i = 0;
        while (i < this.params.length) {
            DeclaredParameter p = this.params[i];
            buff.append(p.getType().toString());
            if (!typesOnly) {
                buff.append(" ").append(p.getName().toString());
            }
            if (i + 1 < this.params.length) {
                buff.append(",");
            }
            ++i;
        }
        if (this.wildParams) {
            buff.append(",*");
        }
        return buff.append(")").toString();
    }

    public Statement[] getBody() {
        return this.body;
    }

    public List<Statement> getBodyAsList() {
        return Arrays.asList(this.body);
    }

    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        try {
            if (ctx.getCallback() != null && !ctx.getCallback().pre((SyntaxElement)this, (ExecutionContext)ctx)) {
                return;
            }
            String typeValue = this.getType().toString();
            Type thisType = ctx.getTypeForName(typeValue);
            if (thisType == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Couldn't find " + typeValue, (SyntaxElement)this.getType()));
            }
            ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable("this", (Object)thisType));
            DeclaredParameter[] declaredParameterArray = this.params;
            int n = this.params.length;
            int n2 = 0;
            while (n2 < n) {
                DeclaredParameter param = declaredParameterArray[n2];
                String paramTypeValue = param.getType().toString();
                Type paramType = ctx.getTypeForName(paramTypeValue);
                if (paramType == null) {
                    issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Couldn't find " + paramTypeValue, (SyntaxElement)param.getType()));
                    paramType = ctx.getObjectType();
                }
                String name = param.getName().toString();
                ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(name, (Object)paramType));
                ++n2;
            }
            int i = 0;
            while (i < this.getBody().length) {
                Statement stmt = this.getBody()[i];
                try {
                    stmt.analyze(ctx, issues);
                }
                catch (RuntimeException ex) {
                    HashMap<String, Statement> info = new HashMap<String, Statement>();
                    info.put("body", stmt);
                    ctx.handleRuntimeException(ex, this, info);
                }
                ++i;
            }
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post((SyntaxElement)this, (ExecutionContext)ctx, null);
            }
        }
    }

    @Override
    public void evaluate(XpandExecutionContext ctx, Object _this, Object ... params) {
        try {
            ctx = (XpandExecutionContext)ctx.cloneWithResource(this.getOwner());
            ctx = this.prepareDeclaredParameters(_this, ctx, params);
            if (ctx.getCallback() != null && !ctx.getCallback().pre((SyntaxElement)this, (ExecutionContext)ctx)) {
                return;
            }
            int i = 0;
            while (i < this.getBody().length) {
                Statement stmt = this.getBody()[i];
                try {
                    stmt.evaluate(ctx);
                }
                catch (RuntimeException ex) {
                    HashMap<String, Statement> info = new HashMap<String, Statement>();
                    info.put("body", stmt);
                    ctx.handleRuntimeException(ex, this, info);
                }
                ++i;
            }
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post((SyntaxElement)this, (ExecutionContext)ctx, null);
            }
        }
    }

    protected XpandExecutionContext prepareDeclaredParameters(Object _this, XpandExecutionContext context, Object ... params) {
        if (_this != null) {
            context = (XpandExecutionContext)context.cloneWithVariable(new Variable("this", _this));
        }
        if (params != null) {
            DeclaredParameter[] params2 = this.getParams();
            int i = 0;
            int x = params2.length;
            while (i < x) {
                Object o = params[i];
                String name = params2[i].getName().toString();
                context = (XpandExecutionContext)context.cloneWithVariable(new Variable(name, o));
                ++i;
            }
        }
        return context;
    }

    public String toString() {
        if (this._stringRepresentation == null) {
            this._stringRepresentation = String.valueOf(this.name.toString()) + this.getParamString(false) + " : " + this.getType().toString();
        }
        return this._stringRepresentation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.toString() == null ? 0 : this.toString().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.toString() == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDefinition other = (AbstractDefinition)obj;
        return this.toString().equals(other.toString());
    }
}

