/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.oclinecore.ui.wizards;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.URIUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.xtext.base.ui.wizards.AbstractFileDialog;
import org.eclipse.ocl.xtext.base.ui.wizards.AbstractFileNewWizardPage;
import org.eclipse.ocl.xtext.oclinecore.ui.messages.OCLinEcoreUIMessages;
import org.eclipse.ocl.xtext.oclinecore.ui.wizards.AbstractOCLinEcoreFileNewWizard;
import org.eclipse.ocl.xtext.oclinecore.ui.wizards.OCLinEcoreFileDialog;

public class OCLinEcoreFileNewWizard
extends AbstractOCLinEcoreFileNewWizard {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void appendImports(StringBuilder s, AbstractFileDialog dialog, IFile newFile) {
        @NonNull List uris = dialog.getURIs();
        if (uris.size() > 0) {
            URI newURI = URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true);
            for (URI uri : uris) {
                URI deresolvedURI = URIUtil.deresolve((URI)uri, (URI)newURI);
                s.append("import '" + ValueUtil.oclToString((Object)deresolvedURI) + "';\n");
            }
            s.append("\n");
        }
    }

    protected @NonNull OCLinEcoreFileDialog createDialog(@NonNull AbstractFileNewWizardPage wizardPage, @Nullable IResource initialSelection) {
        return new OCLinEcoreFileDialog(this, wizardPage, initialSelection);
    }

    public @NonNull String getNewFileExtension() {
        return "oclinecore";
    }

    public @NonNull String getNewFileLabel() {
        return OCLinEcoreUIMessages.NewWizardPage_fileNameLabel;
    }

    public @NonNull String getPageDescription() {
        return OCLinEcoreUIMessages.NewWizardPage_pageDescription;
    }

    public @NonNull String getPageSummary() {
        return OCLinEcoreUIMessages.NewWizardPage_pageSummary;
    }

    public @NonNull String getPageTitle() {
        return OCLinEcoreUIMessages.NewWizardPage_pageTitle;
    }
}

