/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public class ReferenceCounted<T> {
    private final T owner;
    private final AtomicInteger refCount = new AtomicInteger();
    private Runnable disposeAction;
    private final ExecutorService autoReleaseExecutor;

    public ReferenceCounted(T owner, Runnable disposeAction) {
        this(owner, null, disposeAction);
    }

    public ReferenceCounted(T owner, ExecutorService autoReleaseExecutor, Runnable disposeAction) {
        if (disposeAction == null) {
            throw new IllegalArgumentException("null disposeAction");
        }
        this.owner = owner;
        this.autoReleaseExecutor = autoReleaseExecutor;
        this.disposeAction = disposeAction;
    }

    protected ReferenceCounted() {
        this(null);
    }

    protected ReferenceCounted(ExecutorService autoReleaseExecutor) {
        this.owner = this;
        this.disposeAction = new SelfDisposeAction();
        this.autoReleaseExecutor = autoReleaseExecutor;
    }

    public final T retain() {
        this.refCount.incrementAndGet();
        return this.owner;
    }

    public final void release() {
        if (this.refCount.decrementAndGet() <= 0 && this.disposeAction != null) {
            try {
                this.disposeAction.run();
            }
            finally {
                this.disposeAction = null;
            }
        }
    }

    public final T autoRelease() {
        if (this.autoReleaseExecutor == null) {
            throw new IllegalStateException("no auto-release executor available");
        }
        this.autoReleaseExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ReferenceCounted.this.release();
            }
        });
        return this.owner;
    }

    protected void dispose() {
        throw new UnsupportedOperationException("dispose is unimplemented");
    }

    private class SelfDisposeAction
    implements Runnable {
        private SelfDisposeAction() {
        }

        @Override
        public void run() {
            ReferenceCounted.this.dispose();
        }
    }
}

