/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.IRepositoryProvider;
import org.eclipse.emf.cdo.server.RepositoryNotFoundException;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerIndicationWithMonitoring;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.server.ISessionProtocol;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.NotAuthenticatedException;

public class OpenSessionIndication
extends CDOServerIndicationWithMonitoring {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, OpenSessionIndication.class);
    private String repositoryName;
    private String userID;
    private boolean passiveUpdateEnabled;
    private CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode;
    private CDOCommonSession.Options.LockNotificationMode lockNotificationMode;
    private InternalRepository repository;
    private InternalSession session;

    public OpenSessionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)1);
    }

    protected boolean closeChannelAfterException() {
        return true;
    }

    @Override
    protected InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    protected InternalSession getSession() {
        return this.session;
    }

    protected int getIndicatingWorkPercent() {
        return 10;
    }

    @Override
    protected void indicating(CDODataInput in, OMMonitor monitor) throws Exception {
        this.repositoryName = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryName: {0}", new Object[]{this.repositoryName});
        }
        this.userID = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Read userID: {0}", new Object[]{this.userID});
        }
        this.passiveUpdateEnabled = in.readBoolean();
        if (TRACER.isEnabled()) {
            TRACER.format("Read passiveUpdateEnabled: {0}", new Object[]{this.passiveUpdateEnabled});
        }
        this.passiveUpdateMode = (CDOCommonSession.Options.PassiveUpdateMode)in.readEnum(CDOCommonSession.Options.PassiveUpdateMode.class);
        if (TRACER.isEnabled()) {
            TRACER.format("Read passiveUpdateMode: {0}", new Object[]{this.passiveUpdateMode});
        }
        this.lockNotificationMode = (CDOCommonSession.Options.LockNotificationMode)in.readEnum(CDOCommonSession.Options.LockNotificationMode.class);
        if (TRACER.isEnabled()) {
            TRACER.format("Read lockNotificationMode: {0}", new Object[]{this.lockNotificationMode});
        }
    }

    @Override
    protected void responding(CDODataOutput out, OMMonitor monitor) throws Exception {
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            final CDOServerProtocol protocol = this.getProtocol();
            IRepositoryProvider repositoryProvider = protocol.getRepositoryProvider();
            this.repository = (InternalRepository)repositoryProvider.getRepository(this.repositoryName);
            if (this.repository == null) {
                throw new RepositoryNotFoundException(this.repositoryName);
            }
            try {
                InternalSessionManager sessionManager = this.repository.getSessionManager();
                this.session = sessionManager.openSession((ISessionProtocol)protocol);
            }
            catch (NotAuthenticatedException ex) {
                out.writeXInt(0);
                this.flush();
                protocol.getExecutorService().submit(new Runnable(){

                    @Override
                    public void run() {
                        ConcurrencyUtil.sleep((long)500L);
                        protocol.getChannel().close();
                    }
                });
                async.stop();
                monitor.done();
                return;
            }
            if (this.session.getUserID() == null && this.userID != null) {
                this.session.setUserID(this.userID);
            }
            this.session.setPassiveUpdateEnabled(this.passiveUpdateEnabled);
            this.session.setPassiveUpdateMode(this.passiveUpdateMode);
            this.session.setLockNotificationMode(this.lockNotificationMode);
            protocol.setInfraStructure(this.session);
            if (TRACER.isEnabled()) {
                TRACER.format("Writing sessionID: {0}", new Object[]{this.session.getSessionID()});
            }
            out.writeXInt(this.session.getSessionID());
            if (TRACER.isEnabled()) {
                TRACER.format("Writing userID: {0}", new Object[]{this.session.getUserID()});
            }
            out.writeString(this.session.getUserID());
            if (TRACER.isEnabled()) {
                TRACER.format("Writing repositoryUUID: {0}", new Object[]{this.repository.getUUID()});
            }
            out.writeString(this.repository.getUUID());
            out.writeString(this.repository.getName());
            out.writeEnum((Enum)this.repository.getType());
            out.writeEnum((Enum)this.repository.getState());
            out.writeString(this.repository.getStoreType());
            Set objectIDTypes = this.repository.getObjectIDTypes();
            int types = objectIDTypes.size();
            out.writeXInt(types);
            for (CDOID.ObjectType objectIDType : objectIDTypes) {
                out.writeEnum((Enum)objectIDType);
            }
            out.writeXLong(this.repository.getCreationTime());
            out.writeXLong(this.session.getFirstUpdateTime());
            out.writeXInt(this.repository.getBranchManager().getTagModCount());
            out.writeCDOID(this.repository.getRootResourceID());
            out.writeBoolean(this.repository.isAuthenticating());
            out.writeBoolean(this.repository.isSupportingAudits());
            out.writeBoolean(this.repository.isSupportingBranches());
            out.writeBoolean(this.repository.isSupportingUnits());
            out.writeBoolean(this.repository.isSerializingCommits());
            out.writeBoolean(this.repository.isEnsuringReferentialIntegrity());
            out.writeEnum((Enum)this.repository.getIDGenerationLocation());
            out.writeEnum((Enum)this.repository.getCommitInfoStorage());
            InternalCDOPackageUnit[] packageUnits = this.repository.getPackageRegistry(false).getPackageUnits();
            out.writeCDOPackageUnits((CDOPackageUnit[])packageUnits);
        }
        finally {
            async.stop();
            monitor.done();
        }
    }
}

