/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SetNodeVisibilityCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomStyleValueCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.SetPersistentViewCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.UnsetPersistentViewCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;
import org.eclipse.uml2.uml.Stereotype;

public final class StereotypeDisplayCommandExecution {
    private static StereotypeDisplayCommandExecution labelHelper;
    private StereotypeDisplayUtil helper = StereotypeDisplayUtil.getInstance();

    private StereotypeDisplayCommandExecution() {
    }

    public static StereotypeDisplayCommandExecution getInstance() {
        if (labelHelper == null) {
            labelHelper = new StereotypeDisplayCommandExecution();
        }
        return labelHelper;
    }

    public void setVisibility(TransactionalEditingDomain domain, View view, boolean isVisible, boolean inCommandStack) {
        SetNodeVisibilityCommand visibility = new SetNodeVisibilityCommand(domain, view, Boolean.valueOf(isVisible));
        if (!inCommandStack) {
            CommandUtil.executeCommand((Command)visibility, domain);
        } else {
            CommandUtil.executeCommandInStack((Command)visibility, domain);
        }
    }

    public void setPersistency(TransactionalEditingDomain domain, View view, boolean inCommandStack) {
        SetPersistentViewCommand persitence = new SetPersistentViewCommand(domain, view);
        if (!inCommandStack) {
            CommandUtil.executeCommand((Command)persitence, domain);
        } else {
            CommandUtil.executeCommandInStack((Command)persitence, domain);
        }
    }

    public void unsetPersistency(TransactionalEditingDomain domain, View view, boolean inCommandStack) {
        UnsetPersistentViewCommand persistence = new UnsetPersistentViewCommand(domain, view);
        if (!inCommandStack) {
            CommandUtil.executeCommand((Command)persistence, domain);
        } else {
            CommandUtil.executeCommandInStack((Command)persistence, domain);
        }
    }

    public void makeViewPersistant(View view) {
        if (view != null && view.eContainer() != null && view.eContainer() instanceof View) {
            this.makeViewPersistant((View)view.eContainer());
            if (!(view instanceof Edge)) {
                ((View)view.eContainer()).getPersistedChildren().add((Object)view);
                ((View)view.eContainer()).getTransientChildren().remove((Object)view);
            }
        }
    }

    public void removeViewPersistant(View view) {
        if (view != null && view.eContainer() != null && view.eContainer() instanceof View && !(view instanceof Edge)) {
            ((View)view.eContainer()).getTransientChildren().add((Object)view);
            ((View)view.eContainer()).getPersistedChildren().remove((Object)view);
        }
    }

    public void setDepth(TransactionalEditingDomain domain, Stereotype stereotype, View nodeView, String depth, boolean inCommandStack) {
        Object label = null;
        label = this.helper.isStereotypeLabel(nodeView) ? nodeView : this.helper.getStereotypeLabel(nodeView, stereotype);
        CustomStyleValueCommand command = new CustomStyleValueCommand(label, (Object)depth, NotationPackage.eINSTANCE.getStringValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getStringValueStyle_StringValue(), "depth");
        if (inCommandStack) {
            CommandUtil.executeCommandInStack((Command)command, domain);
        } else {
            CommandUtil.executeCommand((Command)command, domain);
        }
    }

    public void setUserVisibility(TransactionalEditingDomain domain, View view, boolean visible) {
        if (view != null && domain != null) {
            CompoundCommand compoundCommand = new CompoundCommand("Set User Visibility");
            SetPersistentViewCommand persitence = new SetPersistentViewCommand(domain, view);
            compoundCommand.append((Command)persitence);
            SetNodeVisibilityCommand visibility = new SetNodeVisibilityCommand(domain, view, Boolean.valueOf(visible));
            compoundCommand.append((Command)visibility);
            CommandUtil.executeCommandInStack((Command)compoundCommand, domain);
        }
    }

    public void setUserVisibilityWithoutPersistence(TransactionalEditingDomain domain, View view, boolean visible) {
        if (view != null && domain != null) {
            SetNodeVisibilityCommand visibility = new SetNodeVisibilityCommand(domain, view, Boolean.valueOf(visible));
            CommandUtil.executeCommandInStack((Command)visibility, domain);
        }
    }

    public void setUserDepth(TransactionalEditingDomain domain, Stereotype stereotype, View label, String depth) {
        if (label != null && depth != null && !depth.isEmpty()) {
            this.setPersistency(domain, label, true);
            this.setDepth(domain, stereotype, label, depth, true);
        }
    }
}

