/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.actions.AbstractShowHideAction;
import org.eclipse.papyrus.uml.diagram.common.dialogs.AbstractCheckedTreeColumnViewerSelectionDialog;
import org.eclipse.papyrus.uml.diagram.menu.actions.ShowHideCompartmentAction;
import org.eclipse.papyrus.uml.diagram.menu.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ShowHideCompartmentSelectionDialog
extends AbstractCheckedTreeColumnViewerSelectionDialog {
    protected static final String ICON_CHECKED = "/icons/complete_tsk.gif";
    protected static final String ICON_UNCHECKED = "/icons/incomplete_tsk.gif";

    public ShowHideCompartmentSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider, 0x1010800, 2);
        this.init();
    }

    protected void computeResult() {
        List<Object> checkedElement = Arrays.asList(this.getTreeViewer().getCheckedElements());
        ArrayList<Object> returnedValues = new ArrayList<Object>();
        returnedValues.addAll(checkedElement);
        this.setResult(returnedValues);
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = super.createSelectionButtons(composite);
        Button propagateToSameType = this.createButton(buttonComposite, 20, Messages.ShowHideCompartmentAction_PropagateToSameType, false);
        PropagateSelectionAdapter listener = new PropagateSelectionAdapter();
        propagateToSameType.addSelectionListener((SelectionListener)listener);
        return buttonComposite;
    }

    public void setInitialElementSelections(List selectedElements) {
        super.setInitialElementSelections(selectedElements);
        for (Object e : selectedElements) {
        }
    }

    protected void init() {
        this.setColumnTitles(new String[]{"Compartments To Display", "Display Compartment Title"});
        this.setColumnWidths(new int[]{350, 180});
        this.setColumnCellLabelProvider(new CellLabelProvider[]{new CompartmentNameProvider(), new TitleVisibilityLabelProvider()});
    }

    protected EditingSupport getEditingSupport(int columnIndex) {
        if (columnIndex == 1) {
            return new NameVisibilityEditingSupport((ColumnViewer)this.getTreeViewer());
        }
        return null;
    }

    protected class CompartmentNameProvider
    extends ColumnLabelProvider {
        private final ILabelProvider labelProvider;

        public CompartmentNameProvider() {
            this.labelProvider = ShowHideCompartmentSelectionDialog.this.getLabelProvider();
        }

        public Image getImage(Object element) {
            return this.labelProvider.getImage(element);
        }

        public String getText(Object element) {
            return this.labelProvider.getText(element);
        }

        public void update(ViewerCell cell) {
            cell.setImage(this.getImage(cell.getElement()));
            cell.setText(this.getText(cell.getElement()));
        }
    }

    public class NameVisibilityEditingSupport
    extends EditingSupport {
        public NameVisibilityEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof ShowHideCompartmentAction.CompartmentEditPartRepresentation) {
                CheckboxCellEditor editor = new CheckboxCellEditor();
                editor.setValue(this.getValue(element));
                return editor;
            }
            return null;
        }

        protected boolean canEdit(Object element) {
            return element instanceof ShowHideCompartmentAction.CompartmentEditPartRepresentation;
        }

        protected Object getValue(Object element) {
            if (element instanceof ShowHideCompartmentAction.CompartmentEditPartRepresentation) {
                return ((ShowHideCompartmentAction.CompartmentEditPartRepresentation)((Object)element)).isTitleVisible();
            }
            return false;
        }

        protected void setValue(Object element, Object value) {
            if (value == null) {
                return;
            }
            if (element instanceof ShowHideCompartmentAction.CompartmentEditPartRepresentation) {
                if (value.equals(true)) {
                    ((ShowHideCompartmentAction.CompartmentEditPartRepresentation)((Object)element)).setTitleVisible(true);
                } else {
                    ((ShowHideCompartmentAction.CompartmentEditPartRepresentation)((Object)element)).setTitleVisible(false);
                }
            }
            ShowHideCompartmentSelectionDialog.this.getTreeViewer().refresh();
        }
    }

    public class PropagateSelectionAdapter
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            ISelection sel = ShowHideCompartmentSelectionDialog.this.getTreeViewer().getSelection();
            if (sel instanceof ITreeSelection) {
                Object[] viewerElements;
                TreePath[] paths = ((ITreeSelection)sel).getPaths();
                if (paths.length != 1) {
                    return;
                }
                Object objSelectedEP = paths[0].getFirstSegment();
                if (!(objSelectedEP instanceof ShowHideCompartmentAction.RootEditPartRepresentation)) {
                    return;
                }
                ShowHideCompartmentAction.RootEditPartRepresentation selectedRootEPRep = (ShowHideCompartmentAction.RootEditPartRepresentation)((Object)objSelectedEP);
                EClass eClass = selectedRootEPRep.getSemanticElement().eClass();
                boolean changedTitle = false;
                Object[] objectArray = viewerElements = ShowHideCompartmentSelectionDialog.this.fContentProvider.getElements(ShowHideCompartmentSelectionDialog.this.fInput);
                int n = viewerElements.length;
                int n2 = 0;
                while (n2 < n) {
                    ShowHideCompartmentAction.RootEditPartRepresentation otherRootEPRep;
                    Object viewerElement = objectArray[n2];
                    if (viewerElement != selectedRootEPRep && viewerElement instanceof ShowHideCompartmentAction.RootEditPartRepresentation && (otherRootEPRep = (ShowHideCompartmentAction.RootEditPartRepresentation)((Object)viewerElement)).getSemanticElement().eClass() == eClass) {
                        Iterator selectedCompartmentIter = selectedRootEPRep.getPossibleElement().iterator();
                        for (AbstractShowHideAction.EditPartRepresentation subElement : otherRootEPRep.getPossibleElement()) {
                            Object selectedCompartment;
                            if (!(subElement instanceof ShowHideCompartmentAction.CompartmentEditPartRepresentation) || !((selectedCompartment = selectedCompartmentIter.next()) instanceof ShowHideCompartmentAction.CompartmentEditPartRepresentation)) continue;
                            ShowHideCompartmentAction.CompartmentEditPartRepresentation selectedCEPR = (ShowHideCompartmentAction.CompartmentEditPartRepresentation)((Object)selectedCompartment);
                            ShowHideCompartmentAction.CompartmentEditPartRepresentation otherCEPR = (ShowHideCompartmentAction.CompartmentEditPartRepresentation)subElement;
                            if (otherCEPR.isTitleVisible() != selectedCEPR.isTitleVisible()) {
                                otherCEPR.setTitleVisible(selectedCEPR.isTitleVisible());
                                changedTitle = true;
                            }
                            boolean isChecked = ShowHideCompartmentSelectionDialog.this.getTreeViewer().getChecked((Object)selectedCEPR);
                            ShowHideCompartmentSelectionDialog.this.getTreeViewer().setChecked((Object)otherCEPR, isChecked);
                        }
                    }
                    ++n2;
                }
                ShowHideCompartmentSelectionDialog.this.updateOKStatus();
                if (changedTitle) {
                    ShowHideCompartmentSelectionDialog.this.getTreeViewer().refresh();
                }
            }
        }
    }

    public class TitleVisibilityLabelProvider
    extends ColumnLabelProvider {
        private static final String EMPTY_STRING = "";

        public String getText(Object element) {
            return EMPTY_STRING;
        }

        public Image getImage(Object element) {
            if (element instanceof ShowHideCompartmentAction.CompartmentEditPartRepresentation) {
                if (((ShowHideCompartmentAction.CompartmentEditPartRepresentation)((Object)element)).isTitleVisible()) {
                    return Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.common", (String)ShowHideCompartmentSelectionDialog.ICON_CHECKED);
                }
                return Activator.getPluginIconImage((String)"org.eclipse.papyrus.uml.diagram.common", (String)ShowHideCompartmentSelectionDialog.ICON_UNCHECKED);
            }
            return super.getImage(element);
        }
    }
}

