/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation.internal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.services.markerlistener.IMarkerEventListener;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.validation.Activator;
import org.eclipse.papyrus.infra.services.validation.IValidationMarkerListener;
import org.eclipse.papyrus.infra.services.validation.IValidationMarkersService;

public class ValidationMarkersService
implements IMarkerEventListener,
IValidationMarkersService {
    private ModelSet modelSet;
    private final Multimap<EObject, IPapyrusMarker> markers = HashMultimap.create();
    private final CopyOnWriteArrayList<IValidationMarkerListener> listeners = new CopyOnWriteArrayList();

    public void init(ServicesRegistry services) throws ServiceException {
        this.modelSet = ServiceUtils.getInstance().getModelSet((Object)services);
    }

    public void startService() throws ServiceException {
    }

    public void disposeService() throws ServiceException {
        this.markers.clear();
        this.modelSet = null;
    }

    public boolean isNotifiedOnInitialMarkerCheck() {
        return true;
    }

    public void notifyMarkerChange(EObject eObjectOfMarker, IPapyrusMarker marker, int addedOrRemoved) {
        try {
            if (marker.exists() && !marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                return;
            }
        }
        catch (CoreException e1) {
            Activator.log.error((Throwable)e1);
        }
        IValidationMarkerListener.MarkerChangeKind kind = addedOrRemoved == 1 ? IValidationMarkerListener.MarkerChangeKind.ADDED : IValidationMarkerListener.MarkerChangeKind.REMOVED;
        switch (kind) {
            case ADDED: {
                this.markers.put((Object)eObjectOfMarker, (Object)marker);
                break;
            }
            case REMOVED: {
                this.markers.values().remove(marker);
            }
        }
        for (IValidationMarkerListener next : this.listeners) {
            try {
                next.notifyMarkerChange(marker, kind);
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in validation marker listener.", (Throwable)e);
            }
        }
    }

    @Override
    public ModelSet getModelSet() {
        return this.modelSet;
    }

    @Override
    public Collection<IPapyrusMarker> getMarkers() {
        return this.markers.values();
    }

    @Override
    public Collection<IPapyrusMarker> getMarkers(EObject object) {
        return this.markers.get((Object)object);
    }

    @Override
    public void addValidationMarkerListener(IValidationMarkerListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void removeValidationMarkerListener(IValidationMarkerListener listener) {
        this.listeners.remove(listener);
    }
}

