/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.properties;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Version {
    public static final Version EMPTY_VERSION = new Version(0, 0, 0);
    private static final String SEPARATOR = ".";
    protected int major;
    protected int minor;
    protected int micro;

    public Version(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public Version(String value) throws IllegalArgumentException {
        try {
            StringTokenizer st = new StringTokenizer(value, SEPARATOR, true);
            this.major = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                st.nextToken();
                this.minor = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    this.micro = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        throw new IllegalArgumentException("invalid format");
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("invalid format");
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public void updateVersion(int maj, int min, int mic) {
        this.major = maj;
        this.minor = min;
        this.micro = mic;
    }

    public static Version parseVersion(String version) {
        if (version == null || version.trim().length() == 0) {
            return EMPTY_VERSION;
        }
        return new Version(version.trim());
    }

    public String toString() {
        return this.major + SEPARATOR + this.minor + SEPARATOR + this.micro;
    }
}

