/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.common.ui;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.gmf.internal.common.ui.FileSelector;
import org.eclipse.papyrus.gmf.internal.common.ui.Messages;
import org.eclipse.papyrus.gmf.internal.common.ui.ResourceLocationProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ModelSelectionPage
extends WizardPage {
    protected final ResourceLocationProvider rloc;
    protected Text uriFld;
    private int settingUriFld;
    protected Button loadBtn;
    private Button browseFsBtn;
    private Button browseWsBtn;
    private Button findInWsBtn;
    private URI uri;
    private Resource resource;
    private ResourceSet resourceSet;
    private boolean readOnly;
    private boolean modelRequired;
    private boolean initialized;
    private String modelFileExtension;

    public ModelSelectionPage(String pageId, ResourceLocationProvider rloc, ResourceSet resourceSet) {
        this(pageId, rloc, resourceSet, null);
    }

    public ModelSelectionPage(String pageId, ResourceLocationProvider rloc, ResourceSet resourceSet, String modelFileExtension) {
        super(pageId);
        this.rloc = rloc;
        this.resourceSet = resourceSet;
        this.setModelFileExtension(modelFileExtension);
    }

    protected final ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        return this.resourceSet;
    }

    public void setModelFileExtension(String fileExtension) {
        this.modelFileExtension = fileExtension;
    }

    protected String getModelFileExtension() {
        return this.modelFileExtension;
    }

    public final void createControl(Composite parent) {
        Composite plate = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        plate.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        plate.setLayoutData((Object)data);
        this.createTitleAndButtonsRow(plate);
        this.createUriRow(plate);
        this.createAdditionalControls(plate);
        this.setControl((Control)plate);
    }

    protected void createTitleAndButtonsRow(Composite parent) {
        Composite plate = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        plate.setLayout((Layout)layout);
        plate.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label(plate, 0);
        label.setText(Messages.ModelSelectionPageModelURI);
        label.setLayoutData((Object)new GridData());
        this.browseFsBtn = new Button(plate, 8);
        this.browseFsBtn.setText(Messages.ModelSelectionPageBrowseFS);
        this.browseFsBtn.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.browseWsBtn = new Button(plate, 8);
        this.browseWsBtn.setText(Messages.ModelSelectionPageBrowseWS);
        this.browseWsBtn.setLayoutData((Object)new GridData());
        this.findInWsBtn = new Button(plate, 8);
        this.findInWsBtn.setText(Messages.ModelSelectionPageFindInWS);
        this.findInWsBtn.setLayoutData((Object)new GridData());
        this.browseFsBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ModelSelectionPage.this.getShell(), 4096);
                fd.setText(Messages.ModelSelectionPageSelectModel);
                String fileName = fd.open();
                if (fileName == null) {
                    return;
                }
                ModelSelectionPage.this.setURI(URI.createFileURI((String)fileName));
                ModelSelectionPage.this.updateURI();
            }
        });
        this.browseWsBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ViewerFilter extFilter = new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        String ext = ModelSelectionPage.this.getModelFileExtension();
                        if (ext != null && element instanceof IFile) {
                            IFile file = (IFile)element;
                            return ext.equals(file.getFileExtension());
                        }
                        return true;
                    }
                };
                IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)ModelSelectionPage.this.getShell(), (String)Messages.ModelSelectionPageSelectModel, (String)Messages.ModelSelectionPageSelectModelDesc, (boolean)false, null, Collections.singletonList(extFilter));
                if (files == null || files.length == 0) {
                    return;
                }
                ModelSelectionPage.this.setURI(URI.createPlatformResourceURI((String)files[0].getFullPath().toString(), (boolean)true));
                ModelSelectionPage.this.updateURI();
            }
        });
        this.findInWsBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IFile file = FileSelector.selectFile(ModelSelectionPage.this.getShell(), Messages.ModelSelectionPageSelectModel, null, null, ModelSelectionPage.this.getModelFileExtension());
                if (file == null) {
                    return;
                }
                ModelSelectionPage.this.setURI(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
                ModelSelectionPage.this.updateURI();
            }
        });
    }

    protected void createUriRow(Composite parent) {
        Composite plate = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        plate.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        plate.setLayoutData((Object)data);
        this.uriFld = new Text(plate, 2052);
        GridData data2 = new GridData();
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        this.uriFld.setLayoutData((Object)data2);
        this.loadBtn = new Button(plate, 8);
        this.loadBtn.setText(Messages.ModelSelectionPageLoad);
        data2 = new GridData();
        this.loadBtn.setLayoutData((Object)data2);
        this.loadBtn.setEnabled(false);
        this.uriFld.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ModelSelectionPage.this.settingUriFld > 0) {
                    return;
                }
                ModelSelectionPage.this.setURI(ModelSelectionPage.this.uriFld.getText());
                ModelSelectionPage.this.setResource(null);
            }
        });
        this.loadBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ModelSelectionPage.this.setResource(ModelSelectionPage.this.loadResource());
            }
        });
    }

    protected void createAdditionalControls(Composite parent) {
    }

    public void setReadOnly(boolean value) {
        this.readOnly = value;
        this.uriFld.setEnabled(!value);
        this.browseFsBtn.setEnabled(!value);
        this.browseWsBtn.setEnabled(!value);
        this.findInWsBtn.setEnabled(!value);
    }

    protected void initControls() {
        if (this.rloc == null || this.getModelFileExtension() == null) {
            return;
        }
        List<URI> uris = this.rloc.getSelectedURIs(this.getModelFileExtension());
        if (!uris.isEmpty()) {
            this.setURI(uris.get(0));
            this.updateURI();
        }
    }

    public void updateURI() {
        if (this.readOnly) {
            return;
        }
        try {
            ++this.settingUriFld;
            if (this.uri != null) {
                this.uriFld.setText(this.uri.toString());
                this.setResource(this.loadResource());
            } else {
                this.uriFld.setText("");
                this.setResource(null);
            }
        }
        finally {
            --this.settingUriFld;
        }
    }

    public void setURI(String uriText) {
        if (this.readOnly) {
            return;
        }
        if (uriText == null || uriText.trim().length() == 0) {
            this.uri = null;
            this.loadBtn.setEnabled(false);
            this.setErrorMessage(null);
            return;
        }
        try {
            this.uri = URI.createURI((String)uriText.trim());
            this.loadBtn.setEnabled(true);
            this.setErrorMessage(null);
        }
        catch (IllegalArgumentException iae) {
            this.uri = null;
            this.loadBtn.setEnabled(false);
            this.setErrorMessage(NLS.bind((String)Messages.ModelSelectionPageBadURI, (Object)iae.getLocalizedMessage()));
            return;
        }
    }

    public void setURI(URI uri) {
        if (this.readOnly) {
            return;
        }
        this.uri = uri;
        this.loadBtn.setEnabled(uri != null);
        this.setErrorMessage(null);
    }

    public final URI getURI() {
        return this.uri;
    }

    protected void unloadResource() {
        if (this.resource != null) {
            if (this.resource.isLoaded()) {
                this.resource.unload();
            }
            this.getResourceSet().getResources().remove((Object)this.resource);
            this.resource = null;
        }
    }

    protected Resource loadResource() {
        this.unloadResource();
        assert (this.uri != null);
        Resource resource = this.getResourceSet().createResource(this.uri, "");
        if (resource == null) {
            this.setErrorMessage(Messages.ModelSelectionPageModelNA);
            return null;
        }
        try {
            resource.load(Collections.EMPTY_MAP);
        }
        catch (IOException ioe) {
            this.setErrorMessage(NLS.bind((String)Messages.ModelSelectionPageErrorLoadingModel, (Object)ioe.getLocalizedMessage()));
            return null;
        }
        this.setErrorMessage(null);
        return resource;
    }

    protected final void setResource(Resource resource) {
        this.unloadResource();
        this.resource = resource;
        this.validatePage();
        this.resourceChanged();
    }

    public void validatePage() {
        if (this.modelRequired) {
            this.setPageComplete(this.resource != null);
        }
    }

    public void setVisible(boolean visible) {
        if (!this.initialized && visible) {
            this.initialized = true;
            this.initControls();
        }
        super.setVisible(visible);
    }

    protected void resourceChanged() {
    }

    public final Resource getResource() {
        return this.resource;
    }

    public final boolean isModelRequired() {
        return this.modelRequired;
    }

    public void setModelRequired(boolean modelRequired) {
        this.modelRequired = modelRequired;
        this.validatePage();
    }
}

