/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.fuml.actions.DefaultCreateObjectActionStrategy;
import org.eclipse.papyrus.moka.fuml.actions.DefaultGetAssociationStrategy;
import org.eclipse.papyrus.moka.fuml.commonbehavior.FIFOGetNextEventStrategy;
import org.eclipse.papyrus.moka.fuml.library.LibraryRegistry;
import org.eclipse.papyrus.moka.fuml.loci.FirstChoiceStrategy;
import org.eclipse.papyrus.moka.fuml.loci.IExecutionFactory;
import org.eclipse.papyrus.moka.fuml.loci.IExecutor;
import org.eclipse.papyrus.moka.fuml.loci.ILocus;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticStrategy;
import org.eclipse.papyrus.moka.kernel.engine.EngineConfiguration;
import org.eclipse.papyrus.moka.pscs.actions.additions.CS_NotNormativeDefaultConstructStrategy;
import org.eclipse.papyrus.moka.pscs.loci.CS_Executor;
import org.eclipse.papyrus.moka.pscs.structuredclassifiers.CS_DefaultRequestPropagationStrategy;
import org.eclipse.papyrus.moka.pscs.structuredclassifiers.CS_DispatchOperationOfInterfaceStrategy;
import org.eclipse.papyrus.moka.pscs.structuredclassifiers.CS_NameBased_StructuralFeatureOfInterfaceAccessStrategy;
import org.eclipse.papyrus.moka.pssm.loci.SM_ExecutionFactory;
import org.eclipse.papyrus.moka.pssm.loci.SM_Locus;
import org.eclipse.papyrus.moka.utils.UMLPrimitiveTypesUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Type;

public class UMLExecutionEngineHelper {
    public static ILocus createLocus() {
        SM_Locus locus = new SM_Locus();
        locus.setExecutor((IExecutor)new CS_Executor());
        locus.setFactory((IExecutionFactory)new SM_ExecutionFactory());
        return locus;
    }

    public static void installBuiltInTypes(EngineConfiguration<?> configuration, ILocus locus) {
        Element source = (Element)configuration.getExecutionSource();
        if (locus != null && source != null) {
            locus.getFactory().addBuiltInType((Type)UMLPrimitiveTypesUtils.getReal((EObject)source));
            locus.getFactory().addBuiltInType((Type)UMLPrimitiveTypesUtils.getInteger((EObject)source));
            locus.getFactory().addBuiltInType((Type)UMLPrimitiveTypesUtils.getBoolean((EObject)source));
            locus.getFactory().addBuiltInType((Type)UMLPrimitiveTypesUtils.getString((EObject)source));
        }
    }

    public static void installLibraries(EngineConfiguration<?> configuration, ILocus locus) {
        Element source = (Element)configuration.getExecutionSource();
        if (locus != null && source.eResource() != null && source.eResource().getResourceSet() != null) {
            LibraryRegistry.getInstance().loadLibraryFactories(source.eResource().getResourceSet());
            LibraryRegistry.getInstance().installLibraries(locus);
        }
    }

    public static void installSemanticStrategies(ILocus locus) {
        if (locus != null) {
            locus.getFactory().setStrategy((ISemanticStrategy)new FirstChoiceStrategy());
            locus.getFactory().setStrategy((ISemanticStrategy)new FIFOGetNextEventStrategy());
            locus.getFactory().setStrategy((ISemanticStrategy)new CS_DispatchOperationOfInterfaceStrategy());
            locus.getFactory().setStrategy((ISemanticStrategy)new CS_NameBased_StructuralFeatureOfInterfaceAccessStrategy());
            locus.getFactory().setStrategy((ISemanticStrategy)new CS_DefaultRequestPropagationStrategy());
            locus.getFactory().setStrategy((ISemanticStrategy)new CS_NotNormativeDefaultConstructStrategy());
            locus.getFactory().setStrategy((ISemanticStrategy)new DefaultGetAssociationStrategy());
            locus.getFactory().setStrategy((ISemanticStrategy)new DefaultCreateObjectActionStrategy());
        }
    }
}

