/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.model.elements.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.papyrus.dsml.validation.model.elements.impl.WrongStereotypeException;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.Category;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IValidationRule;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.Mode;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.Severity;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRuleImpl
implements IValidationRule {
    private static final String CONSTRAINT_POSTFIX = "Constraint";
    private static final String DPT = ".";
    private static final String CONSTRAINT_PKG = "constraints";
    private static final String SA_TARGET = "target";
    private static final String SA_ID = "id";
    private static final String SA_STATUS_CODE = "statusCode";
    private static final String SA_SEVERITY = "severity";
    private static final String SA_MODE = "mode";
    private static final String SA_IS_ENABLED_BY_DEFAULT = "isEnabledByDefault";
    private static final String SA_DESCRIPTION = "description";
    private static final String SA_MESSAGE = "message";
    private String id;
    private Constraint constraint;
    private Stereotype stereotype;
    private List<String> targets;
    private String implementingClass;

    public ValidationRuleImpl(Constraint constraint) throws WrongStereotypeException {
        this.constraint = constraint;
        this.stereotype = constraint.getAppliedStereotype("PapyrusDSMLValidationRule::ValidationRule");
    }

    public ValidationRuleImpl(Constraint constraint, Category parentCategory) throws WrongStereotypeException {
        this(constraint);
        String qname;
        this.id = this.getStereoAttribValue(SA_ID) instanceof String && ((String)this.getStereoAttribValue(SA_ID)).length() > 0 ? (String)this.getStereoAttribValue(SA_ID) : (qname = constraint.getQualifiedName().replace("::", DPT));
        this.implementingClass = "constraints." + this.getName() + CONSTRAINT_POSTFIX;
        this.targets = new ArrayList<String>();
        Object targetsObj = this.getStereoAttribValue(SA_TARGET);
        if (targetsObj instanceof EDataTypeUniqueEList && ((EDataTypeUniqueEList)targetsObj).size() > 0) {
            for (Object target : (EDataTypeUniqueEList)targetsObj) {
                if (!(target instanceof String)) continue;
                this.targets.add((String)target);
            }
        }
    }

    @Override
    public String getName() {
        return this.constraint.getName();
    }

    @Override
    public String getID() {
        return this.id == null ? (String)this.getStereoAttribValue(SA_ID) : this.id;
    }

    @Override
    public Integer getStatusCode() {
        Integer statusCode = (Integer)this.getStereoAttribValue(SA_STATUS_CODE);
        return statusCode == null ? new Integer(1) : statusCode;
    }

    @Override
    public Severity getSeverity() {
        Object severityObj = this.getStereoAttribValue(SA_SEVERITY);
        if (severityObj instanceof Enumerator) {
            Enumerator severity = (Enumerator)severityObj;
            String severityType = severity.getName();
            if (severityType.compareTo(Severity.INFO.name()) == 0) {
                return Severity.INFO;
            }
            if (severityType.compareTo(Severity.WARNING.name()) == 0) {
                return Severity.WARNING;
            }
            if (severityType.compareTo(Severity.CANCEL.name()) == 0) {
                return Severity.CANCEL;
            }
        }
        return Severity.ERROR;
    }

    @Override
    public String getImplementingClass() {
        return this.implementingClass;
    }

    @Override
    public Mode getMode() {
        Object modeObj;
        Object object = modeObj = this.stereotype != null ? this.constraint.getValue(this.stereotype, SA_MODE) : null;
        if (modeObj instanceof Enumerator) {
            Enumerator mode = (Enumerator)modeObj;
            String modeType = mode.getName();
            if (modeType.compareTo(Mode.Batch.name()) == 0) {
                return Mode.Batch;
            }
            if (modeType.compareTo(Mode.Live.name()) == 0) {
                return Mode.Live;
            }
        }
        return Mode.Batch;
    }

    @Override
    public boolean isEnabledByDefault() {
        Object enabledByDefault = this.getStereoAttribValue(SA_IS_ENABLED_BY_DEFAULT);
        return enabledByDefault instanceof Boolean ? (Boolean)enabledByDefault : true;
    }

    @Override
    public String getMessage() {
        return (String)this.getStereoAttribValue(SA_MESSAGE);
    }

    @Override
    public String getDescription() {
        return (String)this.getStereoAttribValue(SA_DESCRIPTION);
    }

    @Override
    public List<String> getTargets() {
        return this.targets;
    }

    @Override
    public Constraint getConstraint() {
        return this.constraint;
    }

    public Object getStereoAttribValue(String attributeName) {
        if (this.stereotype != null) {
            return this.constraint.getValue(this.stereotype, attributeName);
        }
        return null;
    }
}

