/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.ArrayList;
import java.util.Iterator;
import prefuse.data.Node;

public class TreeNodeIterator
implements Iterator {
    private ArrayList m_stack;
    private Node m_root;
    private boolean m_preorder = true;

    public TreeNodeIterator(Node root) {
        this(root, true);
    }

    public TreeNodeIterator(Node root, boolean preorder) {
        this.m_preorder = preorder;
        this.m_root = root;
        this.m_stack = new ArrayList();
        this.m_stack.add(root);
        if (!preorder) {
            Node n = root.getChild(0);
            while (n != null) {
                this.m_stack.add(n);
                n = n.getChild(0);
            }
        }
    }

    public boolean hasNext() {
        return !this.m_stack.isEmpty();
    }

    public Object next() {
        Node x = null;
        if (this.m_preorder) {
            x = (Node)this.m_stack.get(this.m_stack.size() - 1);
            Node c = x.getChild(0);
            if (c != null) {
                this.m_stack.add(c);
            } else {
                c = x.getNextSibling();
                if (c != null) {
                    this.m_stack.set(this.m_stack.size() - 1, c);
                } else {
                    this.m_stack.remove(this.m_stack.size() - 1);
                    while (!this.m_stack.isEmpty()) {
                        c = (Node)this.m_stack.remove(this.m_stack.size() - 1);
                        if (c == this.m_root) break;
                        if ((c = c.getNextSibling()) == null) continue;
                        this.m_stack.add(c);
                        break;
                    }
                }
            }
        } else {
            Node c;
            x = (Node)this.m_stack.remove(this.m_stack.size() - 1);
            if (x != this.m_root && (c = x.getNextSibling()) != null) {
                while (c != null) {
                    this.m_stack.add(c);
                    c = c.getChild(0);
                }
            }
        }
        return x;
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }
}

