/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.Date;

public class TimeLib {
    public static final int MILLENIUM = -1000;
    public static final int CENTURY = -100;
    public static final int DECADE = -10;
    private static final double SECOND_MILLIS = 1000.0;
    private static final double MINUTE_MILLIS = 60000.0;
    private static final double HOUR_MILLIS = 3600000.0;
    private static final double DAY_MILLIS = 8.64054E7;
    private static final double WEEK_MILLIS = 6.048378E8;
    private static final double MONTH_MILLIS = 2.62989955845E9;
    private static final double YEAR_MILLIS = 3.157253316E10;
    private static final double DECADE_MILLIS = 3.157253316E11;
    private static final double CENTURY_MILLIS = 3.157253316E12;
    private static final double MILLENIUM_MILLIS = 3.157253316E13;
    private static final int[] CALENDAR_FIELDS = new int[]{1, 2, 5, 11, 12, 13, 14};

    private TimeLib() {
    }

    public static void increment(Calendar c, int field, int val) {
        if (TimeLib.isMultiYear(field)) {
            c.add(1, -field * val);
        } else {
            c.add(field, val);
        }
    }

    public static int get(Calendar c, int field) {
        if (TimeLib.isMultiYear(field)) {
            int y = c.get(1);
            return -field * (y / -field);
        }
        return c.get(field);
    }

    public static long getDate(Calendar c, int year, int month, int day) {
        c.clear(14);
        c.set(year, month, day, 0, 0, 0);
        return c.getTimeInMillis();
    }

    public static long getTime(Calendar c, int hour, int minute, int second) {
        c.clear(14);
        c.set(1970, 0, 1, hour, minute, second);
        return c.getTimeInMillis();
    }

    public static Date getDate(Class type, long d) {
        try {
            Constructor c = type.getConstructor(Long.TYPE);
            return (Date)c.newInstance(new Long(d));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long getClearedTime(long t, Calendar c, int field) {
        c.setTimeInMillis(t);
        TimeLib.clearTo(c, field);
        return c.getTimeInMillis();
    }

    public static Calendar clearTo(Calendar c, int field) {
        int i = CALENDAR_FIELDS.length - 1;
        while (i >= 1 && field != CALENDAR_FIELDS[i]) {
            int val = CALENDAR_FIELDS[i] == 5 ? 1 : 0;
            c.set(CALENDAR_FIELDS[i], val);
            --i;
        }
        if (TimeLib.isMultiYear(field)) {
            int y = c.get(1);
            y = -field * (y / -field);
            c.set(1, y);
        }
        return c;
    }

    public static boolean isMultiYear(int field) {
        return field == -10 || field == -100 || field == -1000;
    }
}

