/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.awt.Color;
import prefuse.util.collections.IntObjectHashMap;

public class ColorLib {
    public static final char HEX_PREFIX = '#';
    private static final IntObjectHashMap colorMap = new IntObjectHashMap();
    private static int misses = 0;
    private static int lookups = 0;
    private static final float scale = 0.7f;
    public static final float[] CATEGORY_HUES = new float[]{0.0f, 0.083333336f, 0.16666667f, 0.33333334f, 0.5f, 0.5833333f, 0.6666667f, 0.8333333f, 0.9166667f};
    public static final int DEFAULT_MAP_SIZE = 64;

    public static int rgb(int r, int g, int b) {
        return ColorLib.rgba(r, g, b, 255);
    }

    public static int gray(int v) {
        return ColorLib.rgba(v, v, v, 255);
    }

    public static int gray(int v, int a) {
        return ColorLib.rgba(v, v, v, a);
    }

    public static int hex(String hex) {
        if (hex.charAt(0) == '#') {
            hex = hex.substring(1);
        }
        if (hex.length() > 6) {
            int rgb = Integer.parseInt(hex.substring(2), 16);
            int alpha = Integer.parseInt(hex.substring(0, 2), 16);
            return ColorLib.setAlpha(rgb, alpha);
        }
        return ColorLib.setAlpha(Integer.parseInt(hex, 16), 255);
    }

    public static int hsb(float h, float s, float b) {
        return Color.HSBtoRGB(h, s, b);
    }

    public static int hsba(float h, float s, float b, float a) {
        return ColorLib.setAlpha(Color.HSBtoRGB(h, s, b), (int)((double)(a * 255.0f) + 0.5) & 0xFF);
    }

    public static int rgba(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public static int rgba(float r, float g, float b, float a) {
        return ((int)((double)(a * 255.0f) + 0.5) & 0xFF) << 24 | ((int)((double)(r * 255.0f) + 0.5) & 0xFF) << 16 | ((int)((double)(g * 255.0f) + 0.5) & 0xFF) << 8 | (int)((double)(b * 255.0f) + 0.5) & 0xFF;
    }

    public static int color(Color c) {
        return c.getRGB();
    }

    public static int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color & 0xFF;
    }

    public static int alpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int setAlpha(int c, int alpha) {
        return ColorLib.rgba(ColorLib.red(c), ColorLib.green(c), ColorLib.blue(c), alpha);
    }

    public static Color getColor(float r, float g, float b, float a) {
        return ColorLib.getColor(ColorLib.rgba(r, g, b, a));
    }

    public static Color getColor(float r, float g, float b) {
        return ColorLib.getColor(r, g, b, 1.0f);
    }

    public static Color getColor(int r, int g, int b, int a) {
        return ColorLib.getColor(ColorLib.rgba(r, g, b, a));
    }

    public static Color getColor(int r, int g, int b) {
        return ColorLib.getColor(r, g, b, 255);
    }

    public static Color getGrayscale(int v) {
        return ColorLib.getColor(v, v, v, 255);
    }

    public static Color getColor(int rgba) {
        Color c = null;
        c = (Color)colorMap.get(rgba);
        if (c == null) {
            c = new Color(rgba, true);
            colorMap.put(rgba, c);
            ++misses;
        }
        ++lookups;
        return c;
    }

    public static int getCacheMissCount() {
        return misses;
    }

    public static int getCacheLookupCount() {
        return lookups;
    }

    public static void clearCache() {
        colorMap.clear();
    }

    public static int interp(int c1, int c2, double frac) {
        double ifrac = 1.0 - frac;
        return ColorLib.rgba((int)Math.round(frac * (double)ColorLib.red(c2) + ifrac * (double)ColorLib.red(c1)), (int)Math.round(frac * (double)ColorLib.green(c2) + ifrac * (double)ColorLib.green(c1)), (int)Math.round(frac * (double)ColorLib.blue(c2) + ifrac * (double)ColorLib.blue(c1)), (int)Math.round(frac * (double)ColorLib.alpha(c2) + ifrac * (double)ColorLib.alpha(c1)));
    }

    public static int darker(int c) {
        return ColorLib.rgba(Math.max(0, (int)(0.7f * (float)ColorLib.red(c))), Math.max(0, (int)(0.7f * (float)ColorLib.green(c))), Math.max(0, (int)(0.7f * (float)ColorLib.blue(c))), ColorLib.alpha(c));
    }

    public static int brighter(int c) {
        int r = ColorLib.red(c);
        int g = ColorLib.green(c);
        int b = ColorLib.blue(c);
        int i = 3;
        if (r == 0 && g == 0 && b == 0) {
            return ColorLib.rgba(i, i, i, ColorLib.alpha(c));
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return ColorLib.rgba(Math.min(255, (int)((float)r / 0.7f)), Math.min(255, (int)((float)g / 0.7f)), Math.min(255, (int)((float)b / 0.7f)), ColorLib.alpha(c));
    }

    public static int desaturate(int c) {
        int a = c & 0xFF000000;
        float r = (c & 0xFF0000) >> 16;
        float g = (c & 0xFF00) >> 8;
        float b = c & 0xFF;
        int gray = Math.min((int)((r *= 0.2125f) + (g *= 0.7154f) + (b *= 0.0721f)), 255) & 0xFF;
        return a | gray << 16 | gray << 8 | gray;
    }

    public static int saturate(int c, float saturation) {
        float[] hsb = Color.RGBtoHSB(ColorLib.red(c), ColorLib.green(c), ColorLib.blue(c), null);
        return ColorLib.hsb(hsb[0], saturation, hsb[2]);
    }

    public static int[] getCoolPalette(int size) {
        int[] cm = new int[size];
        int i = 0;
        while (i < size) {
            float r = (float)i / Math.max((float)(size - 1), 1.0f);
            cm[i] = ColorLib.rgba(r, 1.0f - r, 1.0f, 1.0f);
            ++i;
        }
        return cm;
    }

    public static int[] getCoolPalette() {
        return ColorLib.getCoolPalette(64);
    }

    public static int[] getHotPalette(int size) {
        int[] cm = new int[size];
        int i = 0;
        while (i < size) {
            float r;
            int n = 3 * size / 8;
            float f = r = i < n ? (float)(i + 1) / (float)n : 1.0f;
            float g = i < n ? 0.0f : (i < 2 * n ? (float)(i - n) / (float)n : 1.0f);
            float b = i < 2 * n ? 0.0f : (float)(i - 2 * n) / (float)(size - 2 * n);
            cm[i] = ColorLib.rgba(r, g, b, 1.0f);
            ++i;
        }
        return cm;
    }

    public static int[] getHotPalette() {
        return ColorLib.getHotPalette(64);
    }

    public static int[] getCategoryPalette(int size, float s1, float s2, float b, float a) {
        int[] cm = new int[size];
        float s = s1;
        int i = 0;
        while (i < size) {
            int j = i % CATEGORY_HUES.length;
            if (j == 0) {
                s = s1 + (float)i / (float)size * (s2 - s1);
            }
            cm[i] = ColorLib.hsba(CATEGORY_HUES[j], s, b, a);
            ++i;
        }
        return cm;
    }

    public static int[] getCategoryPalette(int size) {
        return ColorLib.getCategoryPalette(size, 1.0f, 0.4f, 1.0f, 1.0f);
    }

    public static int[] getHSBPalette(int size, float s, float b) {
        int[] cm = new int[size];
        int i = 0;
        while (i < size) {
            float h = (float)i / (float)(size - 1);
            cm[i] = ColorLib.hsb(h, s, b);
            ++i;
        }
        return cm;
    }

    public static int[] getHSBPalette() {
        return ColorLib.getHSBPalette(64, 1.0f, 1.0f);
    }

    public static int[] getInterpolatedPalette(int size, int c1, int c2) {
        int[] cm = new int[size];
        int i = 0;
        while (i < size) {
            float f = (float)i / (float)(size - 1);
            cm[i] = ColorLib.interp(c1, c2, f);
            ++i;
        }
        return cm;
    }

    public static int[] getInterpolatedPalette(int c1, int c2) {
        return ColorLib.getInterpolatedPalette(64, c1, c2);
    }

    public static int[] getGrayscalePalette(int size) {
        int[] cm = new int[size];
        int i = 0;
        while (i < size) {
            int g = Math.round(255.0f * (0.2f + 0.6f * (float)i / (float)(size - 1)));
            cm[size - i - 1] = ColorLib.gray(g);
            ++i;
        }
        return cm;
    }

    public static int[] getGrayscalePalette() {
        return ColorLib.getGrayscalePalette(64);
    }
}

