/******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation 
 ****************************************************************************/

package org.eclipse.gmf.runtime.diagram.ui.preferences;

import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * Populates default diagram preferences
 * 
 * @author aboyko
 * @since 1.2
 */
public class DefaultDiagramPreferencesInitializer extends
		DiagramPreferenceInitializer {

	@Override
	protected IPreferenceStore getPreferenceStore() {
		return (IPreferenceStore) PreferencesHint.USE_DEFAULTS.getPreferenceStore();
	}

}
