/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramModificationListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.StorageDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.StorageEditorInputProxy;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class StorageDiagramDocumentProvider
extends StorageDocumentProvider
implements IDiagramDocumentProvider {
    @Override
    protected IDocument createEmptyDocument() {
        return new DiagramDocument();
    }

    public IDiagramDocument getDiagramDocument(Object element) {
        IDocument doc = this.getDocument(element);
        if (doc instanceof IDiagramDocument) {
            return (IDiagramDocument)doc;
        }
        return null;
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        super.disposeElementInfo(element, info);
        Object content = info.fDocument.getContent();
        if (content instanceof Diagram && info.fDocument instanceof IDiagramDocument) {
            TransactionalEditingDomain domain = ((IDiagramDocument)info.fDocument).getEditingDomain();
            DiagramIOUtil.unload((TransactionalEditingDomain)domain, (Diagram)((Diagram)content));
            assert (info instanceof DiagramStorageInfo);
        }
        ((DiagramStorageInfo)info).fListener.stopListening();
    }

    @Override
    protected void setDocumentContentFromStorage(IDocument document, IStorage storage) throws CoreException {
        IDiagramDocument diagramDocument = (IDiagramDocument)document;
        TransactionalEditingDomain domain = diagramDocument.getEditingDomain();
        Diagram diagram = DiagramIOUtil.load((TransactionalEditingDomain)domain, (IStorage)storage, (boolean)true, (IProgressMonitor)this.getProgressMonitor());
        document.setContent((Object)diagram);
    }

    @Override
    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput) throws CoreException {
        if (editorInput instanceof StorageEditorInputProxy) {
            StorageEditorInputProxy diagramElement = (StorageEditorInputProxy)editorInput;
            ((IDiagramDocument)document).setEditingDomain(diagramElement.getEditingDomain());
            boolean docContentSet = super.setDocumentContent(document, editorInput);
            return docContentSet;
        }
        return super.setDocumentContent(document, editorInput);
    }

    public IEditorInput createInputWithEditingDomain(IEditorInput editorInput, TransactionalEditingDomain domain) {
        if (editorInput instanceof IStorageEditorInput) {
            return new StorageEditorInputProxy((IStorageEditorInput)editorInput, domain);
        }
        assert (false);
        return null;
    }

    @Override
    public AbstractDocumentProvider.ElementInfo createNewElementInfo(IDocument document) {
        DiagramModificationListener listener = new DiagramModificationListener((AbstractDocumentProvider)this, (DiagramDocument)document);
        DiagramStorageInfo info = new DiagramStorageInfo(document, listener);
        listener.startListening();
        return info;
    }

    private class DiagramStorageInfo
    extends StorageDocumentProvider.StorageInfo {
        DiagramModificationListener fListener;

        public DiagramStorageInfo(IDocument document, DiagramModificationListener listener) {
            super(StorageDiagramDocumentProvider.this, document);
            this.fListener = listener;
        }
    }
}

