/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.internal.merge.impl;

import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.merge.DefaultMerger;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ModelElementChangeLeftTargetMerger
extends DefaultMerger {
    public void applyInOrigin() {
        ModelElementChangeLeftTarget theDiff = (ModelElementChangeLeftTarget)this.diff;
        EObject element = theDiff.getLeftElement();
        EObject parent = theDiff.getLeftElement().eContainer();
        EcoreUtil.remove((EObject)element);
        this.removeDanglingReferences(parent);
        super.applyInOrigin();
    }

    public void undoInTarget() {
        ModelElementChangeLeftTarget theDiff = (ModelElementChangeLeftTarget)this.diff;
        EObject origin = theDiff.getRightParent();
        EObject element = theDiff.getLeftElement();
        EObject newOne = this.copy(element);
        EReference ref = element.eContainmentFeature();
        if (ref != null) {
            try {
                Object containmentRefVal;
                int elementIndex = -1;
                if (ref.isMany() && (containmentRefVal = element.eContainer().eGet((EStructuralFeature)ref)) instanceof List) {
                    List listVal = (List)containmentRefVal;
                    elementIndex = listVal.indexOf(element);
                }
                EFactory.eAdd((EObject)origin, (String)ref.getName(), (Object)newOne, (int)elementIndex);
                this.setXMIID(newOne, this.getXMIID(element));
            }
            catch (FactoryException e) {
                EMFComparePlugin.log((Exception)((Object)e), (boolean)true);
            }
        } else if (origin == null && this.getDiffModel().getRightRoots().size() > 0) {
            ((EObject)this.getDiffModel().getRightRoots().get(0)).eResource().getContents().add((Object)newOne);
        } else if (origin != null) {
            origin.eResource().getContents().add((Object)newOne);
        }
        TreeIterator siblings = this.getDiffModel().eAllContents();
        while (siblings.hasNext()) {
            ReferenceChange link;
            Object op = siblings.next();
            if (op instanceof ReferenceChangeLeftTarget) {
                link = (ReferenceChangeLeftTarget)op;
                if (!link.getRightTarget().equals(element)) continue;
                link.setLeftTarget(newOne);
                continue;
            }
            if (!(op instanceof ReferenceOrderChange) || !(link = (ReferenceOrderChange)op).getReference().equals(ref)) continue;
            link.getRightTarget().add((Object)newOne);
        }
        super.undoInTarget();
    }
}

