/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDLibraryDescriptor;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDOIDMapper;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.transaction.CDOTimeStampContext;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOXATransaction;
import org.eclipse.net4j.util.concurrent.RWLockManager;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CDOSessionProtocol
extends InternalCDOPackageRegistry.PackageLoader {
    public OpenSessionResult openSession(String var1, boolean var2);

    public void loadLibraries(Set<String> var1, File var2);

    public void setPassiveUpdate(Map<CDOID, CDOIDAndVersion> var1, int var2, boolean var3);

    public RepositoryTimeResult getRepositoryTime();

    public Object loadChunk(InternalCDORevision var1, EStructuralFeature var2, int var3, int var4, int var5, int var6);

    public List<InternalCDORevision> loadRevisions(Collection<CDOID> var1, int var2);

    public List<InternalCDORevision> loadRevisionsByTime(Collection<CDOID> var1, int var2, long var3);

    public InternalCDORevision loadRevisionByVersion(CDOID var1, int var2, int var3);

    public List<InternalCDORevision> verifyRevision(List<InternalCDORevision> var1);

    public Collection<CDOTimeStampContext> syncRevisions(Map<CDOID, CDOIDAndVersion> var1, int var2);

    public void openView(int var1, byte var2, long var3);

    public void closeView(int var1);

    public boolean[] setAudit(int var1, long var2, List<InternalCDOObject> var4);

    public void changeSubscription(int var1, List<CDOID> var2, boolean var3, boolean var4);

    public List<Object> query(int var1, AbstractQueryIterator<?> var2);

    public boolean cancelQuery(int var1);

    public void lockObjects(CDOView var1, Map<CDOID, CDOIDAndVersion> var2, long var3, RWLockManager.LockType var5) throws InterruptedException;

    public void unlockObjects(CDOView var1, Collection<? extends CDOObject> var2, RWLockManager.LockType var3);

    public boolean isObjectLocked(CDOView var1, CDOObject var2, RWLockManager.LockType var3, boolean var4);

    public CommitTransactionResult commitTransaction(InternalCDOTransaction.InternalCDOCommitContext var1, OMMonitor var2);

    public CommitTransactionResult commitTransactionPhase1(InternalCDOXATransaction.InternalCDOXACommitContext var1, OMMonitor var2);

    public CommitTransactionResult commitTransactionPhase2(InternalCDOXATransaction.InternalCDOXACommitContext var1, OMMonitor var2);

    public CommitTransactionResult commitTransactionPhase3(InternalCDOXATransaction.InternalCDOXACommitContext var1, OMMonitor var2);

    public CommitTransactionResult commitTransactionCancel(InternalCDOXATransaction.InternalCDOXACommitContext var1, OMMonitor var2);

    public List<CDORemoteSession> getRemoteSessions(InternalCDORemoteSessionManager var1, boolean var2);

    public void unsubscribeRemoteSessions();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CommitTransactionResult {
        private String rollbackMessage;
        private long timeStamp;
        private Map<CDOIDTemp, CDOID> idMappings = new HashMap<CDOIDTemp, CDOID>();
        private CDOReferenceAdjuster referenceAdjuster;
        private InternalCDOTransaction.InternalCDOCommitContext commitContext;

        public CommitTransactionResult(InternalCDOTransaction.InternalCDOCommitContext commitContext, String rollbackMessage) {
            this.rollbackMessage = rollbackMessage;
            this.commitContext = commitContext;
        }

        public CommitTransactionResult(InternalCDOTransaction.InternalCDOCommitContext commitContext, long timeStamp) {
            this.timeStamp = timeStamp;
            this.commitContext = commitContext;
        }

        public CDOReferenceAdjuster getReferenceAdjuster() {
            if (this.referenceAdjuster == null) {
                this.referenceAdjuster = this.createReferenceAdjuster();
            }
            return this.referenceAdjuster;
        }

        public void setReferenceAdjuster(CDOReferenceAdjuster referenceAdjuster) {
            this.referenceAdjuster = referenceAdjuster;
        }

        public InternalCDOTransaction.InternalCDOCommitContext getCommitContext() {
            return this.commitContext;
        }

        public String getRollbackMessage() {
            return this.rollbackMessage;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public Map<CDOIDTemp, CDOID> getIDMappings() {
            return this.idMappings;
        }

        public void addIDMapping(CDOIDTemp oldID, CDOID newID) {
            this.idMappings.put(oldID, newID);
        }

        protected PostCommitReferenceAdjuster createReferenceAdjuster() {
            return new PostCommitReferenceAdjuster(this.commitContext.getTransaction(), new CDOIDMapper(this.idMappings));
        }

        protected static class PostCommitReferenceAdjuster
        implements CDOReferenceAdjuster {
            private CDOIDProvider idProvider;
            private CDOIDMapper idMapper;

            public PostCommitReferenceAdjuster(CDOIDProvider idProvider, CDOIDMapper idMapper) {
                this.idProvider = idProvider;
                this.idMapper = idMapper;
            }

            public CDOIDProvider getIdProvider() {
                return this.idProvider;
            }

            public CDOIDMapper getIdMapper() {
                return this.idMapper;
            }

            public Object adjustReference(Object id) {
                if (id == null || id == CDOID.NULL) {
                    return id;
                }
                if (this.idProvider != null && (id instanceof CDOID || id instanceof InternalEObject)) {
                    id = this.idProvider.provideCDOID(id);
                }
                return this.idMapper.adjustReference(id);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OpenSessionResult {
        private int sessionID;
        private String repositoryUUID;
        private long repositoryCreationTime;
        private RepositoryTimeResult repositoryTimeResult;
        private boolean repositorySupportingAudits;
        private CDOIDLibraryDescriptor libraryDescriptor;
        private List<InternalCDOPackageUnit> packageUnits = new ArrayList<InternalCDOPackageUnit>();

        public OpenSessionResult(int sessionID, String repositoryUUID, long repositoryCreationTime, boolean repositorySupportingAudits, CDOIDLibraryDescriptor libraryDescriptor) {
            this.sessionID = sessionID;
            this.repositoryUUID = repositoryUUID;
            this.repositoryCreationTime = repositoryCreationTime;
            this.repositorySupportingAudits = repositorySupportingAudits;
            this.libraryDescriptor = libraryDescriptor;
        }

        public int getSessionID() {
            return this.sessionID;
        }

        public String getRepositoryUUID() {
            return this.repositoryUUID;
        }

        public long getRepositoryCreationTime() {
            return this.repositoryCreationTime;
        }

        public boolean isRepositorySupportingAudits() {
            return this.repositorySupportingAudits;
        }

        public RepositoryTimeResult getRepositoryTimeResult() {
            return this.repositoryTimeResult;
        }

        public void setRepositoryTimeResult(RepositoryTimeResult repositoryTimeResult) {
            this.repositoryTimeResult = repositoryTimeResult;
        }

        public CDOIDLibraryDescriptor getLibraryDescriptor() {
            return this.libraryDescriptor;
        }

        public List<InternalCDOPackageUnit> getPackageUnits() {
            return this.packageUnits;
        }
    }

    public static final class RepositoryTimeResult {
        private long requested;
        private long indicated;
        private long responded;
        private long confirmed;

        public long getRequested() {
            return this.requested;
        }

        public void setRequested(long requested) {
            this.requested = requested;
        }

        public long getIndicated() {
            return this.indicated;
        }

        public void setIndicated(long indicated) {
            this.indicated = indicated;
        }

        public long getResponded() {
            return this.responded;
        }

        public void setResponded(long responded) {
            this.responded = responded;
        }

        public long getConfirmed() {
            return this.confirmed;
        }

        public void setConfirmed(long confirmed) {
            this.confirmed = confirmed;
        }

        public long getAproximateRepositoryOffset() {
            long latency = this.confirmed - this.requested >> 1;
            long shift = this.confirmed - this.responded;
            return shift - latency;
        }

        public long getAproximateRepositoryTime() {
            long offset = this.getAproximateRepositoryOffset();
            return System.currentTimeMillis() + offset;
        }

        public String toString() {
            return MessageFormat.format("RepositoryTime[requested={0,date} {0,time}, indicated={1,date} {1,time}, responded={2,date} {2,time}, confirmed={3,date} {3,time}]", this.requested, this.indicated, this.responded, this.confirmed);
        }
    }
}

