/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.emf.cdo.common.CDOQueryInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingAuditSupport;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.DBStoreChunkReader;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.LongIDStoreAccessor;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.monitor.ProgressDistributable;
import org.eclipse.net4j.util.om.monitor.ProgressDistributor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStoreAccessor
extends LongIDStoreAccessor
implements IDBStoreAccessor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, DBStoreAccessor.class);
    private Connection connection = null;
    private IPreparedStatementCache statementCache = null;
    private Timer connectionKeepAliveTimer = null;
    @ReflectUtil.ExcludeFromDump
    private final ProgressDistributable<IStoreAccessor.CommitContext>[] ops = ProgressDistributor.array((ProgressDistributable[])new ProgressDistributable[]{new ProgressDistributable.Default<IStoreAccessor.CommitContext>(){

        public void runLoop(int index, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws Exception {
            DBStoreAccessor.super.write(commitContext, monitor.fork());
        }
    }, new ProgressDistributable.Default<IStoreAccessor.CommitContext>(){

        public void runLoop(int index, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws Exception {
        }
    }});

    public DBStoreAccessor(DBStore store, ISession session) throws DBException {
        super((Store)store, session);
    }

    public DBStoreAccessor(DBStore store, ITransaction transaction) throws DBException {
        super((Store)store, transaction);
    }

    @Override
    public DBStore getStore() {
        return (DBStore)super.getStore();
    }

    @Override
    public IPreparedStatementCache getStatementCache() {
        return this.statementCache;
    }

    public DBStoreChunkReader createChunkReader(InternalCDORevision revision, EStructuralFeature feature) {
        return new DBStoreChunkReader(this, (CDORevision)revision, feature);
    }

    @Deprecated
    public CloseableIterator<CDOID> readObjectIDs() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Selecting object IDs");
        }
        return this.getStore().getMappingStrategy().readObjectIDs(this);
    }

    public CDOClassifierRef readObjectType(CDOID id) {
        if (TRACER.isEnabled()) {
            TRACER.format("Selecting object type: {0}", new Object[]{id});
        }
        return this.getStore().getMappingStrategy().readObjectType(this, id);
    }

    protected EClass getObjectType(CDOID id) {
        EClass result = this.getStore().getRepository().getRevisionManager().getObjectType(id);
        if (result == null) {
            CDOClassifierRef type = this.readObjectType(id);
            if (type == null) {
                return null;
            }
            IRepository repository = this.getStore().getRepository();
            CDOPackageRegistry packageRegistry = repository.getPackageRegistry();
            result = (EClass)type.resolve((EPackage.Registry)packageRegistry);
        }
        return result;
    }

    public InternalCDORevision readRevision(CDOID id, int listChunk, IStoreAccessor.AdditionalRevisionCache cache) {
        EClass eClass;
        if (TRACER.isEnabled()) {
            TRACER.format("Selecting revision: {0}", new Object[]{id});
        }
        if ((eClass = this.getObjectType(id)) == null) {
            return null;
        }
        InternalCDORevision revision = (InternalCDORevision)CDORevisionUtil.createRevision((EClass)eClass, (CDOID)id);
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        IClassMapping mapping = mappingStrategy.getClassMapping(eClass);
        if (mapping.readRevision(this, revision, listChunk)) {
            return revision;
        }
        return null;
    }

    public InternalCDORevision readRevisionByTime(CDOID id, int listChunk, IStoreAccessor.AdditionalRevisionCache cache, long timeStamp) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        if (!mappingStrategy.hasAuditSupport()) {
            throw new UnsupportedOperationException("Mapping strategy does not support audits.");
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Selecting revision: {0}, timestamp={1,date} {1,time}", new Object[]{id, timeStamp});
        }
        EClass eClass = this.getObjectType(id);
        InternalCDORevision revision = (InternalCDORevision)CDORevisionUtil.createRevision((EClass)eClass, (CDOID)id);
        IClassMappingAuditSupport mapping = (IClassMappingAuditSupport)((Object)mappingStrategy.getClassMapping(eClass));
        if (mapping.readRevisionByTime(this, revision, timeStamp, listChunk)) {
            return revision;
        }
        return null;
    }

    public InternalCDORevision readRevisionByVersion(CDOID id, int listChunk, IStoreAccessor.AdditionalRevisionCache cache, int version) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        EClass eClass = this.getObjectType(id);
        InternalCDORevision revision = (InternalCDORevision)CDORevisionUtil.createRevision((EClass)eClass, (CDOID)id);
        IClassMapping mapping = mappingStrategy.getClassMapping(eClass);
        boolean success = false;
        if (mappingStrategy.hasAuditSupport()) {
            if (TRACER.isEnabled()) {
                TRACER.format("Selecting revision: {0}, version={1}", new Object[]{id, version});
            }
            success = ((IClassMappingAuditSupport)((Object)mapping)).readRevisionByVersion(this, revision, version, listChunk);
        } else {
            if (TRACER.isEnabled()) {
                TRACER.format("Selecting current base revision: {0}", new Object[]{id});
            }
            if ((success = mapping.readRevision(this, revision, listChunk)) && revision.getVersion() != version) {
                throw new IllegalStateException("Can only retrieve current version " + revision.getVersion() + " for " + id + " - version requested was " + version + ".");
            }
        }
        return success ? revision : null;
    }

    public void queryResources(IStoreAccessor.QueryResourcesContext context) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        mappingStrategy.queryResources(this, context);
    }

    public IQueryHandler getQueryHandler(CDOQueryInfo info) {
        return null;
    }

    public CloseableIterator<Object> createQueryIterator(CDOQueryInfo queryInfo) {
        throw new UnsupportedOperationException();
    }

    public void refreshRevisions() {
    }

    public void write(IStoreAccessor.CommitContext context, OMMonitor monitor) {
        ProgressDistributor distributor = this.getStore().getAccessorWriteDistributor();
        distributor.run(this.ops, (Object)context, monitor);
    }

    protected void writeRevisionDeltas(InternalCDORevisionDelta[] revisionDeltas, long created, OMMonitor monitor) {
        IMappingStrategy mappingStrategy = this.getStore().getMappingStrategy();
        if (!mappingStrategy.hasDeltaSupport()) {
            throw new UnsupportedOperationException("Mapping strategy does not support revision deltas.");
        }
        monitor.begin((double)revisionDeltas.length);
        try {
            InternalCDORevisionDelta[] internalCDORevisionDeltaArray = revisionDeltas;
            int n = revisionDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevisionDelta delta = internalCDORevisionDeltaArray[n2];
                this.writeRevisionDelta(delta, created, monitor.fork());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void writeRevisionDelta(InternalCDORevisionDelta delta, long created, OMMonitor monitor) {
        EClass eClass = this.getObjectType(delta.getID());
        IClassMappingDeltaSupport mapping = (IClassMappingDeltaSupport)((Object)this.getStore().getMappingStrategy().getClassMapping(eClass));
        mapping.writeRevisionDelta(this, delta, created, monitor);
    }

    protected void writeRevisions(InternalCDORevision[] revisions, OMMonitor monitor) {
        try {
            monitor.begin((double)revisions.length);
            InternalCDORevision[] internalCDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                this.writeRevision(revision, monitor.fork());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void writeRevision(InternalCDORevision revision, OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing revision: {0}", new Object[]{revision});
        }
        EClass eClass = revision.getEClass();
        IClassMapping mapping = this.getStore().getMappingStrategy().getClassMapping(eClass);
        mapping.writeRevision(this, revision, monitor);
    }

    protected void detachObjects(CDOID[] detachedObjects, long revised, OMMonitor monitor) {
        try {
            monitor.begin((double)detachedObjects.length);
            CDOID[] cDOIDArray = detachedObjects;
            int n = detachedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                CDOID id = cDOIDArray[n2];
                this.detachObject(id, revised, monitor.fork());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void detachObject(CDOID id, long revised, OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Detaching object: {0}", new Object[]{id});
        }
        EClass eClass = this.getObjectType(id);
        IClassMapping mapping = this.getStore().getMappingStrategy().getClassMapping(eClass);
        mapping.detachObject(this, id, revised, monitor);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public final void commit(OMMonitor monitor) {
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        if (TRACER.isEnabled()) {
            TRACER.format("--- DB COMMIT ---", new Object[0]);
        }
        try {
            try {
                this.getConnection().commit();
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            async.stop();
            monitor.done();
        }
    }

    protected final void rollback(IStoreAccessor.CommitContext commitContext) {
        if (TRACER.isEnabled()) {
            TRACER.format("--- DB ROLLBACK ---", new Object[0]);
        }
        try {
            this.getConnection().rollback();
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    protected void doActivate() throws Exception {
        this.connection = this.getStore().getConnection();
        this.connectionKeepAliveTimer = new Timer("Connection-Keep-Alive-" + this.toString());
        this.connectionKeepAliveTimer.schedule((TimerTask)new ConnectionKeepAliveTask(), 14400000L, 14400000L);
        this.statementCache = CDODBUtil.createStatementCache();
        this.statementCache.setConnection(this.connection);
        LifecycleUtil.activate((Object)this.statementCache);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.statementCache);
        this.connectionKeepAliveTimer.cancel();
        this.connectionKeepAliveTimer = null;
        DBUtil.close((Connection)this.connection);
        this.connection = null;
    }

    protected void doPassivate() throws Exception {
        this.connection.rollback();
    }

    protected void doUnpassivate() throws Exception {
    }

    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        return this.getStore().getMetaDataManager().loadPackageUnit(this.getConnection(), packageUnit);
    }

    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        return this.getStore().getMetaDataManager().readPackageUnits(this.getConnection());
    }

    public void writePackageUnits(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        monitor.begin(2.0);
        try {
            this.getStore().getMetaDataManager().writePackageUnits(this.getConnection(), packageUnits, monitor.fork());
            this.getStore().getMappingStrategy().createMapping(this.getConnection(), packageUnits, monitor.fork());
        }
        finally {
            monitor.done();
        }
    }

    private class ConnectionKeepAliveTask
    extends TimerTask {
        public static final long EXECUTION_PERIOD = 14400000L;

        private ConnectionKeepAliveTask() {
        }

        public void run() {
            block6: {
                Statement stmt = null;
                try {
                    try {
                        if (TRACER.isEnabled()) {
                            TRACER.trace("DB connection keep-alive task activated.");
                        }
                        stmt = DBStoreAccessor.this.connection.createStatement();
                        stmt.executeQuery("SELECT 1 FROM " + CDODBSchema.REPOSITORY);
                    }
                    catch (SQLException e) {
                        OM.LOG.error("DB connection keep-alive failed.", (Throwable)e);
                        DBUtil.close((Statement)stmt);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    DBUtil.close(stmt);
                    throw throwable;
                }
                DBUtil.close((Statement)stmt);
            }
        }
    }
}

