/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.CDODBSchema;
import org.eclipse.emf.cdo.server.internal.db.DBStoreAccessor;
import org.eclipse.emf.cdo.server.internal.db.MetaDataManager;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.messages.Messages;
import org.eclipse.emf.cdo.spi.server.LongIDStore;
import org.eclipse.emf.cdo.spi.server.StoreAccessorPool;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.spi.db.DBSchema;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.ProgressDistributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStore
extends LongIDStore
implements IDBStore {
    public static final String TYPE = "db";
    private long creationTime;
    private boolean firstTime;
    private IMappingStrategy mappingStrategy;
    private IDBSchema dbSchema;
    private IDBAdapter dbAdapter;
    private IDBConnectionProvider dbConnectionProvider;
    @ReflectUtil.ExcludeFromDump
    private transient ProgressDistributor accessorWriteDistributor = new ProgressDistributor.Geometric(){

        public String toString() {
            String result = "accessorWriteDistributor";
            if (DBStore.this.getRepository() != null) {
                result = String.valueOf(result) + ": " + DBStore.this.getRepository().getName();
            }
            return result;
        }
    };
    @ReflectUtil.ExcludeFromDump
    private transient StoreAccessorPool readerPool = new StoreAccessorPool((IStore)this, null);
    @ReflectUtil.ExcludeFromDump
    private transient StoreAccessorPool writerPool = new StoreAccessorPool((IStore)this, null);
    private transient IMetaDataManager metaDataManager;

    public DBStore() {
        super(TYPE, DBStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.REVISION, IStore.ChangeFormat.DELTA}), DBStore.set((Object[])new IStore.RevisionTemporality[]{IStore.RevisionTemporality.AUDITING, IStore.RevisionTemporality.NONE}), DBStore.set((Object[])new IStore.RevisionParallelism[]{IStore.RevisionParallelism.NONE}));
    }

    @Override
    public IMappingStrategy getMappingStrategy() {
        return this.mappingStrategy;
    }

    public void setMappingStrategy(IMappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
        mappingStrategy.setStore(this);
        this.setRevisionTemporality(mappingStrategy.hasAuditSupport() ? IStore.RevisionTemporality.AUDITING : IStore.RevisionTemporality.NONE);
    }

    @Override
    public IDBAdapter getDBAdapter() {
        return this.dbAdapter;
    }

    public void setDBAdapter(IDBAdapter dbAdapter) {
        this.dbAdapter = dbAdapter;
    }

    @Override
    public IDBConnectionProvider getDBConnectionProvider() {
        return this.dbConnectionProvider;
    }

    public void setDbConnectionProvider(IDBConnectionProvider dbConnectionProvider) {
        this.dbConnectionProvider = dbConnectionProvider;
    }

    public void setDataSource(DataSource dataSource) {
        this.dbConnectionProvider = DBUtil.createConnectionProvider((DataSource)dataSource);
    }

    public ProgressDistributor getAccessorWriteDistributor() {
        return this.accessorWriteDistributor;
    }

    @Override
    public IDBSchema getDBSchema() {
        return this.dbSchema;
    }

    @Override
    public DBStoreAccessor getReader(ISession session) {
        return (DBStoreAccessor)super.getReader(session);
    }

    @Override
    public DBStoreAccessor getWriter(ITransaction transaction) {
        return (DBStoreAccessor)super.getWriter(transaction);
    }

    protected StoreAccessorPool getReaderPool(ISession session, boolean forReleasing) {
        return this.readerPool;
    }

    protected StoreAccessorPool getWriterPool(IView view, boolean forReleasing) {
        return this.writerPool;
    }

    protected DBStoreAccessor createReader(ISession session) throws DBException {
        return new DBStoreAccessor(this, session);
    }

    protected DBStoreAccessor createWriter(ITransaction transaction) throws DBException {
        return new DBStoreAccessor(this, transaction);
    }

    protected Connection getConnection() {
        Connection connection = this.dbConnectionProvider.getConnection();
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        if (connection == null) {
            throw new DBException("No connection from connection provider: " + this.dbConnectionProvider);
        }
        return connection;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkNull(this.mappingStrategy, Messages.getString("DBStore.2"));
        this.checkNull(this.dbAdapter, Messages.getString("DBStore.1"));
        this.checkNull(this.dbConnectionProvider, Messages.getString("DBStore.0"));
        this.checkState(this.getRevisionTemporality() == IStore.RevisionTemporality.AUDITING == this.mappingStrategy.hasAuditSupport(), Messages.getString("DBStore.7"));
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.dbSchema = this.createSchema();
        this.metaDataManager = new MetaDataManager(this);
        LifecycleUtil.activate((Object)this.metaDataManager);
        Connection connection = this.getConnection();
        LifecycleUtil.activate((Object)this.mappingStrategy);
        try {
            Set createdTables = CDODBSchema.INSTANCE.create(this.dbAdapter, connection);
            if (createdTables.contains(CDODBSchema.REPOSITORY)) {
                this.firstStart(connection);
            } else {
                this.reStart(connection);
            }
            connection.commit();
        }
        finally {
            DBUtil.close((Connection)connection);
        }
    }

    protected void firstStart(Connection connection) {
        this.creationTime = this.getStartupTime();
        this.firstTime = true;
        DBUtil.insertRow((Connection)connection, (IDBAdapter)this.dbAdapter, (IDBTable)CDODBSchema.REPOSITORY, (Object[])new Object[]{this.creationTime, 1, this.creationTime, 0, -1L, -1L});
        OM.LOG.info(MessageFormat.format(Messages.getString("DBStore.8"), this.creationTime));
    }

    protected void reStart(Connection connection) {
        this.creationTime = DBUtil.selectMaximumLong((Connection)connection, (IDBField)CDODBSchema.REPOSITORY_CREATED);
        long lastMetaId = DBUtil.selectMaximumLong((Connection)connection, (IDBField)CDODBSchema.REPOSITORY_NEXT_METAID);
        long lastObjectID = DBUtil.selectMaximumLong((Connection)connection, (IDBField)CDODBSchema.REPOSITORY_NEXT_CDOID);
        if (lastObjectID == -1L || this.getLastMetaID() == -1L) {
            OM.LOG.info(Messages.getString("DBStore.9"));
            lastObjectID = this.mappingStrategy.repairAfterCrash(this.dbAdapter, connection);
            lastMetaId = DBUtil.selectMaximumLong((Connection)connection, (IDBField)CDODBSchema.PACKAGE_INFOS_META_UB);
            OM.LOG.info(MessageFormat.format(Messages.getString("DBStore.10"), lastObjectID, lastMetaId));
        }
        this.setLastMetaID(lastMetaId);
        this.setLastObjectID(lastObjectID);
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(CDODBSchema.REPOSITORY);
        builder.append(" SET ");
        builder.append(CDODBSchema.REPOSITORY_STARTS);
        builder.append("=");
        builder.append(CDODBSchema.REPOSITORY_STARTS);
        builder.append("+1, ");
        builder.append(CDODBSchema.REPOSITORY_STARTED);
        builder.append("=");
        builder.append(this.getStartupTime());
        builder.append(", ");
        builder.append(CDODBSchema.REPOSITORY_STOPPED);
        builder.append("=0, ");
        builder.append(CDODBSchema.REPOSITORY_NEXT_CDOID);
        builder.append("=");
        builder.append(-1L);
        builder.append(", ");
        builder.append(CDODBSchema.REPOSITORY_NEXT_METAID);
        builder.append("=");
        builder.append(-1L);
        String sql = builder.toString();
        int count = DBUtil.update((Connection)connection, (String)sql);
        if (count == 0) {
            throw new DBException("No row updated in table " + CDODBSchema.REPOSITORY);
        }
    }

    protected void doDeactivate() throws Exception {
        Connection connection = null;
        LifecycleUtil.deactivate((Object)this.metaDataManager);
        this.metaDataManager = null;
        try {
            connection = this.getConnection();
            LifecycleUtil.deactivate((Object)this.mappingStrategy);
            StringBuilder builder = new StringBuilder();
            builder.append("UPDATE ");
            builder.append(CDODBSchema.REPOSITORY);
            builder.append(" SET ");
            builder.append(CDODBSchema.REPOSITORY_STOPPED);
            builder.append("=");
            builder.append(this.getShutdownTime());
            builder.append(", ");
            builder.append(CDODBSchema.REPOSITORY_NEXT_CDOID);
            builder.append("=");
            builder.append(this.getLastObjectID());
            builder.append(", ");
            builder.append(CDODBSchema.REPOSITORY_NEXT_METAID);
            builder.append("=");
            builder.append(this.getLastMetaID());
            String sql = builder.toString();
            int count = DBUtil.update((Connection)connection, (String)sql);
            if (count == 0) {
                throw new DBException("No row updated in table " + CDODBSchema.REPOSITORY);
            }
            connection.commit();
        }
        finally {
            DBUtil.close((Connection)connection);
        }
        this.readerPool.dispose();
        this.writerPool.dispose();
        super.doDeactivate();
    }

    protected IDBSchema createSchema() {
        String name = this.getRepository().getName();
        return new DBSchema(name);
    }

    protected long getStartupTime() {
        return System.currentTimeMillis();
    }

    protected long getShutdownTime() {
        return System.currentTimeMillis();
    }

    @Override
    public IMetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public Set<IStore.ChangeFormat> getSupportedChangeFormats() {
        if (this.mappingStrategy.hasDeltaSupport()) {
            return DBStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.DELTA});
        }
        return DBStore.set((Object[])new IStore.ChangeFormat[]{IStore.ChangeFormat.REVISION});
    }
}

