/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.DOMHandler;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.resource.QvtCompilationErrorException;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.Messages;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalResourceImpl
extends XMIResourceImpl {
    public QvtOperationalResourceImpl(URI uri) {
        super(uri);
    }

    public void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded()) {
            Notification notification = null;
            this.isLoading = true;
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            try {
                try {
                    URI normalizedUri = this.getURIConverter().normalize(this.getURI());
                    CompiledModule compiledModule = TransformationUtil.getQvtModule(normalizedUri).getModule();
                    this.fillCompilationDiagnostic(compiledModule, normalizedUri);
                    if (compiledModule.getModule() == null) {
                        throw new IOException(NLS.bind((String)Messages.QvtResource_moduleCompilationErrors, (Object)normalizedUri, Arrays.asList(compiledModule.getErrors())));
                    }
                    notification = this.setLoaded(true);
                    this.getContents().add((Object)compiledModule.getModule());
                }
                catch (MdaException e) {
                    throw new Resource.IOWrappedException((Exception)((Object)e));
                }
            }
            catch (Throwable throwable) {
                this.isLoading = false;
                if (notification != null) {
                    this.eNotify(notification);
                }
                this.setModified(false);
                throw throwable;
            }
            this.isLoading = false;
            if (notification != null) {
                this.eNotify(notification);
            }
            this.setModified(false);
        }
    }

    private void fillCompilationDiagnostic(CompiledModule compiledModule, URI uri) {
        QvtMessage msg;
        this.warnings = this.getWarnings();
        QvtMessage[] qvtMessageArray = compiledModule.getWarnings();
        int n = qvtMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            msg = qvtMessageArray[n2];
            this.warnings.add((Object)new QvtCompilationErrorException(msg, uri.toString()));
            ++n2;
        }
        this.errors = this.getErrors();
        qvtMessageArray = compiledModule.getErrors();
        n = qvtMessageArray.length;
        n2 = 0;
        while (n2 < n) {
            msg = qvtMessageArray[n2];
            this.errors.add((Object)new QvtCompilationErrorException(msg, uri.toString()));
            ++n2;
        }
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void doLoad(InputSource inputSource, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void doLoad(Node node, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Document save(Document doc, Map<?, ?> options, DOMHandler handler) {
        throw new UnsupportedOperationException();
    }

    public void save(Map<?, ?> options) throws IOException {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isTrackingModification() {
        return false;
    }
}

