/*******************************************************************************
 * Copyright (c) 2012, 2018 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
package org.eclipse.qvtd.xtext.qvtrelation.cs2as;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.PivotHelper;
import org.eclipse.ocl.xtext.base.cs2as.CS2ASConversion;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.essentialocl.cs2as.EssentialOCLCS2AS;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationHelper;

public class QVTrelationCS2AS extends EssentialOCLCS2AS
{
	public QVTrelationCS2AS(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull BaseCSResource csResource, @NonNull ASResource asResource) {
		super(environmentFactory, csResource, asResource);
	}

	@Override
	protected @NonNull QVTrelationCSContainmentVisitor createContainmentVisitor(@NonNull CS2ASConversion converter) {
		return new QVTrelationCSContainmentVisitor(converter);
	}

	@Override
	protected @NonNull PivotHelper createHelper() {
		return new QVTrelationHelper(environmentFactory);
	}

	@Override
	protected @NonNull QVTrelationCSLeft2RightVisitor createLeft2RightVisitor(@NonNull CS2ASConversion converter) {
		return new QVTrelationCSLeft2RightVisitor(converter);
	}

	@Override
	protected @NonNull QVTrelationCSPostOrderVisitor createPostOrderVisitor(@NonNull CS2ASConversion converter) {
		return new QVTrelationCSPostOrderVisitor(converter);
	}

	@Override
	protected @NonNull QVTrelationCSPreOrderVisitor createPreOrderVisitor(@NonNull CS2ASConversion converter) {
		return new QVTrelationCSPreOrderVisitor(converter);
	}
}
