/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.nativelib;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.Operation;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclUndefined;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMTuple;

public class SOTSExpression2 {
    private static final boolean debug = false;
    private static String[] tokenNames = new String[]{"EOF", "DOT", "COMA", "EXCL", "EQ", "PLUS", "LSQUARE", "RSQUARE", "LPAREN", "RPAREN", "INT", "STRING", "IDENT", "ISA"};
    private String exp;
    private Reader in;
    private Token readAhead = null;

    public SOTSExpression2(String exp) {
        this.exp = exp;
        this.in = new StringReader(exp);
    }

    public ASMOclAny exec(StackFrame frame, ASMTuple args) throws IOException {
        ASMOclAny ret = this.exp(frame, args);
        return ret;
    }

    private ASMOclAny exp(StackFrame frame, ASMTuple args) throws IOException {
        ASMOclAny ret = null;
        Token t = null;
        t = this.next();
        if (t.type == 8) {
            ret = this.exp(frame, args);
            this.match(9);
            return ret;
        }
        if (t.type == 11 || t.type == 10) {
            ret = this.convValue(t);
        } else {
            this.unread(t);
            ret = this.simpleExp(frame, args);
        }
        t = this.next();
        if (t.type == 5) {
            ASMOclAny right = this.exp(frame, args);
            if (right == null) {
                ret = null;
            } else if (ret instanceof ASMInteger) {
                ret = ASMInteger.operatorPlus(frame, (ASMInteger)ret, (ASMInteger)right);
            } else if (ret instanceof ASMString) {
                ret = right instanceof ASMString ? ASMString.operatorPlus(frame, (ASMString)ret, (ASMString)right) : ASMString.operatorPlus(frame, (ASMString)ret, new ASMString(right.toString()));
            } else {
                ATLLogger.severe((String)("Could not add type " + ASMOclAny.oclType(frame, ret) + "."));
            }
        } else {
            this.unread(t);
        }
        return ret;
    }

    private ASMOclAny simpleExp(StackFrame frame, ASMTuple args) throws IOException {
        Token t = null;
        ASMOclAny ret = null;
        t = this.match(12);
        ret = args.get(frame, t.value);
        boolean done = false;
        block6: do {
            t = this.next();
            ASMModelElement ame = null;
            ASMSequence col = null;
            ASMOclAny value = null;
            switch (t.type) {
                case 0: {
                    done = true;
                    break;
                }
                case 1: {
                    Iterator i;
                    t = this.next();
                    if (t.type != 12 && t.type != 11) {
                        this.error(t);
                    }
                    ret = this.toCollection(ret);
                    col = new ASMSequence();
                    Token n = this.next();
                    if (n.type == 8) {
                        this.match(9);
                        i = ((ASMSequence)ret).iterator();
                        while (i.hasNext()) {
                            ASMOclAny o = (ASMOclAny)i.next();
                            Operation oper = ((ASMExecEnv)frame.getExecEnv()).getOperation(o.getType(), t.value);
                            if (oper != null) {
                                ASMOclAny v = oper.exec(frame.enterFrame(oper, Arrays.asList(o)));
                                col.add(v);
                                continue;
                            }
                            frame.printStackTrace("Could not find operation " + t.value + " on " + o.getType() + " having supertypes: " + o.getType().getSupertypes());
                        }
                    } else {
                        this.unread(n);
                        i = ((ASMSequence)ret).iterator();
                        while (i.hasNext()) {
                            ame = (ASMModelElement)i.next();
                            if (t.type == 12) {
                                ASMOclAny v = ame.get(frame, t.value);
                                if (v instanceof ASMOclUndefined) continue;
                                col.add(v);
                                continue;
                            }
                            col.add(new ASMString(t.value));
                        }
                    }
                    ret = ASMSequence.flatten(frame, col);
                    break;
                }
                case 2: {
                    if (ret != null && (!(ret instanceof ASMSequence) || ASMSequence.size(frame, (ASMSequence)ret).getSymbol() != 0)) continue block6;
                    ret = value = this.exp(frame, args);
                    break;
                }
                case 6: {
                    t = this.next();
                    ret = this.toCollection(ret);
                    col = new ASMSequence();
                    if (t.type == 13) {
                        this.match(8);
                        String mname = this.match((int)12).value;
                        this.match(3);
                        String mename = this.match((int)12).value;
                        this.match(9);
                        String expectedTypeName = String.valueOf(mname) + "!" + mename;
                        Iterator i = ((ASMSequence)ret).iterator();
                        while (i.hasNext()) {
                            ame = (ASMModelElement)i.next();
                            String typeName = ASMOclAny.oclType(frame, ame).toString();
                            if (!typeName.equals(expectedTypeName)) continue;
                            col.add(ame);
                        }
                        ret = col;
                    } else if (t.type == 10) {
                        this.unread(t);
                        ((ASMInteger)this.exp(frame, args)).getSymbol();
                        ret = ASMSequence.size(frame, (ASMSequence)ret).getSymbol() > 0 ? (ASMOclAny)((ASMSequence)ret).iterator().next() : null;
                    } else {
                        if (t.type != 12) {
                            this.error(t);
                        }
                        String propName = t.value;
                        this.match(4);
                        value = this.exp(frame, args);
                        Iterator i = ((ASMCollection)ret).iterator();
                        while (i.hasNext()) {
                            ame = (ASMModelElement)i.next();
                            if (!ame.get(frame, propName).equals(value)) continue;
                            col.add(ame);
                        }
                        ret = col;
                    }
                    this.match(7);
                    break;
                }
                default: {
                    this.unread(t);
                    done = true;
                }
            }
        } while (!done);
        return ret;
    }

    private ASMOclAny toCollection(ASMOclAny value) {
        ASMSequence ret = null;
        if (value instanceof ASMSequence) {
            ret = (ASMSequence)value;
        } else {
            ASMOclAny elem = value;
            ret = new ASMSequence();
            if (elem != null) {
                ret.add(elem);
            }
        }
        return ret;
    }

    private ASMOclAny convValue(Token value) {
        ASMOclAny ret = null;
        ret = value.type == 10 ? new ASMInteger(Integer.parseInt(value.value)) : new ASMString(value.value);
        return ret;
    }

    private void error(Token t) throws IOException {
        throw new IOException("ERROR: unexpected " + t);
    }

    private Token match(int type) throws IOException {
        Token ret = this.next();
        if (ret.type != type) {
            this.error(ret);
        }
        return ret;
    }

    private void unread(Token t) {
        this.readAhead = t;
    }

    private Token next() throws IOException {
        Token ret = null;
        String value = "";
        if (this.readAhead != null) {
            Token tmp = this.readAhead;
            this.readAhead = null;
            return tmp;
        }
        int c = this.in.read();
        switch (c) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                do {
                    this.in.mark(1);
                } while ((c = this.in.read()) == 32 || c == 9 || c == 10 || c == 13);
                this.in.reset();
                ret = this.next();
                break;
            }
            case -1: {
                ret = new Token(0, "<EOF>");
                break;
            }
            case 46: {
                ret = new Token(1, ".");
                break;
            }
            case 44: {
                ret = new Token(2, ",");
                break;
            }
            case 33: {
                ret = new Token(3, "!");
                break;
            }
            case 61: {
                ret = new Token(4, "=");
                break;
            }
            case 43: {
                ret = new Token(5, "+");
                break;
            }
            case 91: {
                ret = new Token(6, "[");
                break;
            }
            case 93: {
                ret = new Token(7, "]");
                break;
            }
            case 40: {
                ret = new Token(8, "(");
                break;
            }
            case 41: {
                ret = new Token(9, ")");
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                do {
                    value = String.valueOf(value) + (char)c;
                    this.in.mark(1);
                } while ((c = this.in.read()) >= 48 && c <= 57);
                this.in.reset();
                ret = new Token(10, value);
                break;
            }
            case 39: {
                while ((c = this.in.read()) != 39) {
                    value = String.valueOf(value) + (char)c;
                }
                ret = new Token(11, value);
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 122: {
                do {
                    value = String.valueOf(value) + (char)c;
                    this.in.mark(1);
                } while ((c = this.in.read()) >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 95);
                this.in.reset();
                if (value.equals("ISA")) {
                    ret = new Token(13, value);
                    break;
                }
                ret = new Token(12, value);
                break;
            }
            case 36: {
                ret = this.next();
                break;
            }
            default: {
                ATLLogger.severe((String)("ERROR: unexpected char '" + (char)c + "'."));
                ret = this.next();
            }
        }
        return ret;
    }

    private class Token {
        public static final int EOF = 0;
        public static final int DOT = 1;
        public static final int COMA = 2;
        public static final int EXCL = 3;
        public static final int EQ = 4;
        public static final int PLUS = 5;
        public static final int LSQUARE = 6;
        public static final int RSQUARE = 7;
        public static final int LPAREN = 8;
        public static final int RPAREN = 9;
        public static final int INT = 10;
        public static final int STRING = 11;
        public static final int IDENT = 12;
        public static final int ISA = 13;
        public int type;
        public String value;

        public Token(int type, String value) {
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return String.valueOf(tokenNames[this.type]) + ":" + this.value;
        }
    }
}

