/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.compatibility;

import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.Messages;
import org.eclipse.m2m.atl.adt.ui.compatibility.CompatibilityUtils;
import org.eclipse.m2m.atl.adt.ui.compatibility.RestartDialog;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CompatibilityDialog
extends TitleAreaDialog {
    private CheckboxTableViewer fProjectsTable;
    private CheckboxTableViewer fConfTable;

    public CompatibilityDialog(Shell shell, IWorkbenchWindow window) {
        super(shell);
        this.setShellStyle(0x410 | this.getShellStyle());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String title = Messages.getString("CompatibilityDialog.0");
        shell.setText(title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.getString("CompatibilityDialog.1"));
        this.setMessage(Messages.getString("CompatibilityDialog.2"));
        TabFolder tabFolder = new TabFolder(area, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite projectsComposite = new Composite((Composite)tabFolder, 0);
        projectsComposite.setLayout((Layout)new GridLayout(2, false));
        projectsComposite.setLayoutData((Object)new GridData(1808));
        TabItem projectItem = new TabItem(tabFolder, 0);
        projectItem.setText(Messages.getString("CompatibilityDialog.3"));
        projectItem.setControl((Control)projectsComposite);
        this.fProjectsTable = CheckboxTableViewer.newCheckList((Composite)projectsComposite, (int)2816);
        this.fProjectsTable.getTable().setLayoutData((Object)new GridData(1808));
        ProjectContentProvider provider = new ProjectContentProvider();
        this.fProjectsTable.setContentProvider((IContentProvider)provider);
        this.fProjectsTable.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.fProjectsTable.setInput((Object)provider);
        Composite buttonsGroup = new Composite(projectsComposite, 1024);
        buttonsGroup.setLayout((Layout)new GridLayout());
        Button selectAll = new Button(buttonsGroup, 0x1000000);
        selectAll.setText(Messages.getString("CompatibilityDialog.4"));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompatibilityDialog.this.fProjectsTable.setAllChecked(true);
            }
        });
        Button deselectAll = new Button(buttonsGroup, 0x1000000);
        deselectAll.setText(Messages.getString("CompatibilityDialog.5"));
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompatibilityDialog.this.fProjectsTable.setAllChecked(false);
            }
        });
        Composite confComposite = new Composite((Composite)tabFolder, 0);
        confComposite.setLayout((Layout)new GridLayout(2, false));
        confComposite.setLayoutData((Object)new GridData(1808));
        TabItem confItem = new TabItem(tabFolder, 0);
        confItem.setText(Messages.getString("CompatibilityDialog.6"));
        confItem.setControl((Control)confComposite);
        this.fConfTable = CheckboxTableViewer.newCheckList((Composite)confComposite, (int)2816);
        this.fConfTable.getTable().setLayoutData((Object)new GridData(1808));
        ConfContentProvider confProvider = new ConfContentProvider();
        this.fConfTable.setContentProvider((IContentProvider)confProvider);
        this.fConfTable.setLabelProvider((IBaseLabelProvider)new ConfLabelProvider());
        this.fConfTable.setInput((Object)confProvider);
        Composite confButtonsGroup = new Composite(confComposite, 1024);
        confButtonsGroup.setLayout((Layout)new GridLayout());
        Button confSelectAll = new Button(confButtonsGroup, 0x1000000);
        confSelectAll.setText(Messages.getString("CompatibilityDialog.7"));
        confSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompatibilityDialog.this.fConfTable.setAllChecked(true);
            }
        });
        Button confDeselectAll = new Button(confButtonsGroup, 0x1000000);
        confDeselectAll.setText(Messages.getString("CompatibilityDialog.8"));
        confDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompatibilityDialog.this.fConfTable.setAllChecked(false);
            }
        });
        return tabFolder;
    }

    protected void okPressed() {
        try {
            boolean restart;
            CompatibilityUtils.convertProjects(this.fProjectsTable.getCheckedElements());
            if (CompatibilityUtils.convertConfigurations(this.fConfTable.getCheckedElements()) && (restart = RestartDialog.openQuestion(this.getShell(), true))) {
                PlatformUI.getWorkbench().restart();
            }
        }
        catch (CoreException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        super.okPressed();
    }

    class ConfContentProvider
    implements IStructuredContentProvider {
        ConfContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            try {
                return CompatibilityUtils.getConfigurations();
            }
            catch (CoreException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ConfLabelProvider
    implements ITableLabelProvider {
        ConfLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return AtlUIPlugin.getImage("atl_logo.gif");
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((ILaunchConfiguration)element).getName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class ProjectContentProvider
    implements IStructuredContentProvider {
        ProjectContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            try {
                return CompatibilityUtils.getProjects();
            }
            catch (CoreException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ProjectLabelProvider
    implements ITableLabelProvider {
        ProjectLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return AtlUIPlugin.getImage("atl_project.png");
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((IProject)element).getName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

