/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util;

import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.InMemoryMetricReader;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricID;

public class TelemetryHistogramMetric {
    private final TelemetryMetricID metricId;

    public TelemetryHistogramMetric(TelemetryMetricID metricId) {
        this.metricId = metricId;
    }

    public Collection<HistogramPointData> getHistogramPoints() {
        InMemoryMetricReader reader = InMemoryMetricReader.current();
        return reader.getPointData(this.metricId);
    }

    public Optional<Long> getHistogramCount() {
        Collection<HistogramPointData> hpd = this.getHistogramPoints();
        if (hpd.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(hpd.stream().mapToLong(pd -> pd.getCounts().stream().reduce(0L, Long::sum)).sum());
    }

    public boolean isPresent() {
        return !this.getHistogramPoints().isEmpty();
    }
}

