/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.ls.commons;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4mp.commons.codeaction.CodeActionData;
import org.eclipse.lsp4mp.commons.codeaction.MicroProfileCodeActionId;

public class CodeActionFactory {
    public static CodeAction remove(String title, MicroProfileCodeActionId id, Range range, TextDocumentItem document, Diagnostic diagnostic) {
        return CodeActionFactory.replace(title, id, range, "", document, diagnostic);
    }

    public static CodeAction insert(String title, MicroProfileCodeActionId id, Position position, String insertText, TextDocumentItem document, Diagnostic diagnostic) {
        return CodeActionFactory.insert(title, id, position, insertText, document, Arrays.asList(diagnostic));
    }

    public static CodeAction insert(String title, MicroProfileCodeActionId id, Position position, String insertText, TextDocumentItem document, List<Diagnostic> diagnostics) {
        CodeAction insertContentAction = new CodeAction(title);
        insertContentAction.setKind("quickfix");
        insertContentAction.setDiagnostics(diagnostics);
        insertContentAction.setData((Object)new CodeActionData(id));
        TextEdit edit = new TextEdit(new Range(position, position), insertText);
        VersionedTextDocumentIdentifier versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier(document.getUri(), Integer.valueOf(document.getVersion()));
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(versionedTextDocumentIdentifier, Collections.singletonList(edit));
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)));
        insertContentAction.setEdit(workspaceEdit);
        return insertContentAction;
    }

    public static CodeAction replace(String title, MicroProfileCodeActionId id, Range range, String replaceText, TextDocumentItem document, Diagnostic diagnostic) {
        CodeAction replaceContentAction = new CodeAction(title);
        replaceContentAction.setKind("quickfix");
        replaceContentAction.setDiagnostics(Arrays.asList(diagnostic));
        replaceContentAction.setData((Object)new CodeActionData(id));
        TextEdit edit = new TextEdit(range, replaceText);
        VersionedTextDocumentIdentifier versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier(document.getUri(), Integer.valueOf(document.getVersion()));
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(versionedTextDocumentIdentifier, Collections.singletonList(edit));
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit)));
        replaceContentAction.setEdit(workspaceEdit);
        return replaceContentAction;
    }

    public static boolean isDiagnosticCode(Either<String, Integer> diagnosticCode, String code) {
        if (diagnosticCode == null || diagnosticCode.isRight()) {
            return false;
        }
        return code.equals(diagnosticCode.getLeft());
    }
}

