/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesScope;
import org.eclipse.lsp4mp.commons.metadata.ConfigurationMetadata;
import org.eclipse.lsp4mp.commons.metadata.ItemHint;
import org.eclipse.lsp4mp.commons.metadata.ItemMetadata;
import org.eclipse.lsp4mp.commons.metadata.ValueHint;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.internal.core.PropertiesCollector;
import org.junit.Assert;
import org.junit.Test;

public class PropertiesCollectorTest {
    @Test
    public void merge() {
        ConfigurationMetadata configuration = new ConfigurationMetadata();
        PropertiesCollector collector = new PropertiesCollector(configuration, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
        ConfigurationMetadata toMerge = PropertiesCollectorTest.createToMerge();
        collector.merge(toMerge);
        Assert.assertEquals((long)2L, (long)configuration.getProperties().size());
        ConfigurationMetadata dupMerge = PropertiesCollectorTest.createDuplicateMerge();
        collector.merge(dupMerge);
        Assert.assertEquals((long)3L, (long)configuration.getProperties().size());
    }

    @Test
    public void mergeWithOnlySources() {
        ConfigurationMetadata configuration = new ConfigurationMetadata();
        PropertiesCollector collector = new PropertiesCollector(configuration, MicroProfilePropertiesScope.ONLY_SOURCES);
        ConfigurationMetadata toMerge = PropertiesCollectorTest.createToMerge();
        collector.merge(toMerge);
        Assert.assertEquals((long)1L, (long)configuration.getProperties().size());
    }

    @Test
    public void mergeWithReplace() {
        ConfigurationMetadata configuration = new ConfigurationMetadata();
        PropertiesCollector collector = new PropertiesCollector(configuration, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
        ConfigurationMetadata toMerge = PropertiesCollectorTest.createToMerge();
        collector.merge(toMerge, IPropertiesCollector.MergingStrategy.REPLACE);
        Assert.assertEquals((long)2L, (long)configuration.getProperties().size());
        Assert.assertNull((Object)((ItemMetadata)configuration.getProperties().get(0)).getDescription());
        ConfigurationMetadata dupMerge = PropertiesCollectorTest.createDuplicateMerge();
        collector.merge(dupMerge, IPropertiesCollector.MergingStrategy.REPLACE);
        Assert.assertEquals((long)2L, (long)configuration.getProperties().size());
        Assert.assertNotNull((Object)((ItemMetadata)configuration.getProperties().get(1)).getDescription());
    }

    @Test
    public void mergeWithIgnore() {
        ConfigurationMetadata configuration = new ConfigurationMetadata();
        PropertiesCollector collector = new PropertiesCollector(configuration, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
        ConfigurationMetadata toMerge = PropertiesCollectorTest.createToMerge();
        collector.merge(toMerge, IPropertiesCollector.MergingStrategy.IGNORE_IF_EXISTS);
        Assert.assertEquals((long)2L, (long)configuration.getProperties().size());
        Assert.assertNull((Object)((ItemMetadata)configuration.getProperties().get(0)).getDescription());
        ConfigurationMetadata dupMerge = PropertiesCollectorTest.createDuplicateMerge();
        collector.merge(dupMerge, IPropertiesCollector.MergingStrategy.IGNORE_IF_EXISTS);
        Assert.assertEquals((long)2L, (long)configuration.getProperties().size());
        Assert.assertNull((Object)((ItemMetadata)configuration.getProperties().get(0)).getDescription());
    }

    private static ConfigurationMetadata createToMerge() {
        ConfigurationMetadata toMerge = new ConfigurationMetadata();
        toMerge.setProperties(new ArrayList());
        ItemMetadata binary = new ItemMetadata();
        binary.setName("binaryProperty");
        toMerge.getProperties().add(binary);
        ItemMetadata source = new ItemMetadata();
        source.setSource(Boolean.valueOf(true));
        toMerge.getProperties().add(source);
        return toMerge;
    }

    private static ConfigurationMetadata createDuplicateMerge() {
        ConfigurationMetadata dupMerge = new ConfigurationMetadata();
        dupMerge.setProperties(new ArrayList());
        ItemMetadata binary2 = new ItemMetadata();
        binary2.setName("binaryProperty");
        binary2.setDescription("binary property with description");
        dupMerge.getProperties().add(binary2);
        return dupMerge;
    }

    @Test
    public void mergeHintsWithIgnore() {
        ConfigurationMetadata configuration1 = new ConfigurationMetadata();
        PropertiesCollector collector = new PropertiesCollector(configuration1, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
        ItemHint hint1 = collector.getItemHint("logging");
        hint1.getValues().add(PropertiesCollectorTest.vh("OFF", "OFF [1]"));
        hint1.getValues().add(PropertiesCollectorTest.vh("SEVERE", "SEVERE [1]"));
        hint1.getValues().add(PropertiesCollectorTest.vh("INFO", "INFO [1]"));
        ConfigurationMetadata configuration2 = new ConfigurationMetadata();
        ItemHint hint2 = new ItemHint();
        hint2.setName("logging");
        hint2.setValues(new ArrayList<ValueHint>(Arrays.asList(PropertiesCollectorTest.vh("DEBUG", "DEBUG [2]"), PropertiesCollectorTest.vh("INFO", "INFO [2]"), PropertiesCollectorTest.vh("OFF", "OFF [2]"))));
        configuration2.setHints(new ArrayList<ItemHint>(Arrays.asList(hint2)));
        collector.merge(configuration2, IPropertiesCollector.MergingStrategy.IGNORE_IF_EXISTS);
        Assert.assertEquals((long)1L, (long)configuration1.getHints().size());
        Assert.assertEquals((long)4L, (long)((ItemHint)configuration1.getHints().get(0)).getValues().size());
        Assert.assertEquals((Object)"OFF [1]", (Object)((ValueHint)((ItemHint)configuration1.getHints().get(0)).getValues().get(0)).getDescription());
        Assert.assertEquals((Object)"SEVERE [1]", (Object)((ValueHint)((ItemHint)configuration1.getHints().get(0)).getValues().get(1)).getDescription());
        Assert.assertEquals((Object)"INFO [1]", (Object)((ValueHint)((ItemHint)configuration1.getHints().get(0)).getValues().get(2)).getDescription());
        Assert.assertEquals((Object)"DEBUG [2]", (Object)((ValueHint)((ItemHint)configuration1.getHints().get(0)).getValues().get(3)).getDescription());
    }

    @Test
    public void mergeHintsWithReplace() {
        ConfigurationMetadata configuration1 = new ConfigurationMetadata();
        PropertiesCollector collector = new PropertiesCollector(configuration1, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
        ItemHint hint1 = collector.getItemHint("logging");
        hint1.getValues().add(PropertiesCollectorTest.vh("OFF", "OFF [1]"));
        hint1.getValues().add(PropertiesCollectorTest.vh("SEVERE", "SEVERE [1]"));
        hint1.getValues().add(PropertiesCollectorTest.vh("INFO", "INFO [1]"));
        ConfigurationMetadata configuration2 = new ConfigurationMetadata();
        ItemHint hint2 = new ItemHint();
        hint2.setName("logging");
        hint2.setValues(new ArrayList<ValueHint>(Arrays.asList(PropertiesCollectorTest.vh("DEBUG", "DEBUG [2]"), PropertiesCollectorTest.vh("INFO", "INFO [2]"), PropertiesCollectorTest.vh("OFF", "OFF [2]"))));
        configuration2.setHints(new ArrayList<ItemHint>(Arrays.asList(hint2)));
        collector.merge(configuration2, IPropertiesCollector.MergingStrategy.REPLACE);
        Assert.assertEquals((long)1L, (long)configuration1.getHints().size());
        Assert.assertEquals((long)4L, (long)((ItemHint)configuration1.getHints().get(0)).getValues().size());
        Assert.assertEquals((Object)"SEVERE [1]", (Object)((ValueHint)((ItemHint)configuration1.getHints().get(0)).getValues().get(0)).getDescription());
        Assert.assertEquals((Object)"DEBUG [2]", (Object)((ValueHint)((ItemHint)configuration1.getHints().get(0)).getValues().get(1)).getDescription());
        Assert.assertEquals((Object)"INFO [2]", (Object)((ValueHint)((ItemHint)configuration1.getHints().get(0)).getValues().get(2)).getDescription());
        Assert.assertEquals((Object)"OFF [2]", (Object)((ValueHint)((ItemHint)configuration1.getHints().get(0)).getValues().get(3)).getDescription());
    }

    @Test
    public void mergeHintsWithForce() {
        ConfigurationMetadata configuration1 = new ConfigurationMetadata();
        PropertiesCollector collector = new PropertiesCollector(configuration1, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
        ItemHint hint1 = collector.getItemHint("logging");
        hint1.getValues().add(PropertiesCollectorTest.vh("OFF", "OFF [1]"));
        hint1.getValues().add(PropertiesCollectorTest.vh("SEVERE", "SEVERE [1]"));
        hint1.getValues().add(PropertiesCollectorTest.vh("INFO", "INFO [1]"));
        ConfigurationMetadata configuration2 = new ConfigurationMetadata();
        ItemHint hint2 = new ItemHint();
        hint2.setName("logging");
        hint2.setValues(new ArrayList<ValueHint>(Arrays.asList(PropertiesCollectorTest.vh("DEBUG", "DEBUG [2]"), PropertiesCollectorTest.vh("INFO", "INFO [2]"), PropertiesCollectorTest.vh("OFF", "OFF [2]"))));
        configuration2.setHints(new ArrayList<ItemHint>(Arrays.asList(hint2)));
        collector.merge(configuration2, IPropertiesCollector.MergingStrategy.FORCE);
        Assert.assertEquals((long)1L, (long)configuration1.getHints().size());
        Assert.assertEquals((long)6L, (long)((ItemHint)configuration1.getHints().get(0)).getValues().size());
        Assert.assertEquals((Object)"OFF [1]", (Object)((ValueHint)((ItemHint)configuration1.getHints().get(0)).getValues().get(0)).getDescription());
        Assert.assertEquals((Object)"SEVERE [1]", (Object)((ValueHint)((ItemHint)configuration1.getHints().get(0)).getValues().get(1)).getDescription());
        Assert.assertEquals((Object)"INFO [1]", (Object)((ValueHint)((ItemHint)configuration1.getHints().get(0)).getValues().get(2)).getDescription());
        Assert.assertEquals((Object)"DEBUG [2]", (Object)((ValueHint)((ItemHint)configuration1.getHints().get(0)).getValues().get(3)).getDescription());
        Assert.assertEquals((Object)"INFO [2]", (Object)((ValueHint)((ItemHint)configuration1.getHints().get(0)).getValues().get(4)).getDescription());
        Assert.assertEquals((Object)"OFF [2]", (Object)((ValueHint)((ItemHint)configuration1.getHints().get(0)).getValues().get(5)).getDescription());
    }

    private static ValueHint vh(String value, String description) {
        ValueHint debug = new ValueHint();
        debug.setValue(value);
        debug.setDescription(description);
        return debug;
    }
}

