/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.annotations;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Tuple;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.annotations.ErrorCode;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;

public class AnnotationDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        String uri = context.getUri();
        IJDTUtils utils = JDTUtilsLSImpl.getInstance();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (unit != null) {
            int n;
            IType[] types;
            int n2;
            IType[] iTypeArray;
            IType[] annotations;
            IPackageDeclaration[] packages;
            ArrayList<Tuple.Two> annotatables = new ArrayList<Tuple.Two>();
            String[] validAnnotations = new String[]{"jakarta.annotation.Generated"};
            String[] validTypeAnnotations = new String[]{"jakarta.annotation.Generated", "jakarta.annotation.Resource", "jakarta.annotation.Resources"};
            String[] validMethodAnnotations = new String[]{"jakarta.annotation.Generated", "jakarta.annotation.PostConstruct", "jakarta.annotation.PreDestroy", "jakarta.annotation.Resource"};
            IPackageDeclaration[] iPackageDeclarationArray = packages = unit.getPackageDeclarations();
            int n3 = packages.length;
            int n4 = 0;
            while (n4 < n3) {
                IPackageDeclaration p = iPackageDeclarationArray[n4];
                iTypeArray = annotations = p.getAnnotations();
                n2 = annotations.length;
                int n5 = 0;
                while (n5 < n2) {
                    IType annotation = iTypeArray[n5];
                    if (AnnotationDiagnosticsParticipant.isValidAnnotation(annotation.getElementName(), validAnnotations)) {
                        annotatables.add(new Tuple.Two((Object)annotation, (Object)p));
                    }
                    ++n5;
                }
                ++n4;
            }
            annotations = types = unit.getAllTypes();
            int n6 = types.length;
            n3 = 0;
            while (n3 < n6) {
                IField[] fields;
                IAnnotation[] iAnnotationArray;
                IField[] parameters;
                int n7;
                IMethod[] methods;
                IAnnotation[] annotations2;
                IType type = annotations[n3];
                IAnnotation[] iAnnotationArray2 = annotations2 = type.getAnnotations();
                int n8 = annotations2.length;
                n2 = 0;
                while (n2 < n8) {
                    IAnnotation annotation = iAnnotationArray2[n2];
                    if (AnnotationDiagnosticsParticipant.isValidAnnotation(annotation.getElementName(), validTypeAnnotations)) {
                        annotatables.add(new Tuple.Two((Object)annotation, (Object)type));
                    }
                    ++n2;
                }
                IMethod[] iMethodArray = methods = type.getMethods();
                int n9 = methods.length;
                n8 = 0;
                while (n8 < n9) {
                    IMethod method = iMethodArray[n8];
                    IAnnotation[] iAnnotationArray3 = annotations2 = method.getAnnotations();
                    n7 = annotations2.length;
                    int n10 = 0;
                    while (n10 < n7) {
                        IAnnotation annotation = iAnnotationArray3[n10];
                        if (AnnotationDiagnosticsParticipant.isValidAnnotation(annotation.getElementName(), validMethodAnnotations)) {
                            annotatables.add(new Tuple.Two((Object)annotation, (Object)method));
                        }
                        ++n10;
                    }
                    parameters = method.getParameters();
                    iAnnotationArray = parameters;
                    n = parameters.length;
                    n7 = 0;
                    while (n7 < n) {
                        IAnnotation parameter = iAnnotationArray[n7];
                        IAnnotation[] iAnnotationArray4 = annotations2 = parameter.getAnnotations();
                        int n11 = annotations2.length;
                        int n12 = 0;
                        while (n12 < n11) {
                            IAnnotation annotation = iAnnotationArray4[n12];
                            if (AnnotationDiagnosticsParticipant.isValidAnnotation(annotation.getElementName(), validAnnotations)) {
                                annotatables.add(new Tuple.Two((Object)annotation, (Object)parameter));
                            }
                            ++n12;
                        }
                        ++n7;
                    }
                    ++n8;
                }
                parameters = fields = type.getFields();
                int n13 = fields.length;
                n9 = 0;
                while (n9 < n13) {
                    IField field = parameters[n9];
                    iAnnotationArray = annotations2 = field.getAnnotations();
                    n = annotations2.length;
                    n7 = 0;
                    while (n7 < n) {
                        IAnnotation annotation2 = iAnnotationArray[n7];
                        if (AnnotationDiagnosticsParticipant.isValidAnnotation(annotation2.getElementName(), validTypeAnnotations)) {
                            annotatables.add(new Tuple.Two((Object)annotation2, (Object)field));
                        }
                        ++n7;
                    }
                    ++n9;
                }
                ++n3;
            }
            for (Tuple.Two annotatable : annotatables) {
                IMethod method;
                IAnnotation annotation = (IAnnotation)annotatable.getFirst();
                IAnnotatable element = (IAnnotatable)annotatable.getSecond();
                if (DiagnosticUtils.isMatchedAnnotation(unit, annotation, "jakarta.annotation.Generated")) {
                    IMemberValuePair[] field = annotation.getMemberValuePairs();
                    int fields = field.length;
                    int methods = 0;
                    while (methods < fields) {
                        String date;
                        IMemberValuePair pair = field[methods];
                        if (pair.getMemberName().equals("date") && pair.getValue() instanceof String && !(date = (String)pair.getValue()).equals("") && !Pattern.matches("^([\\+-]?\\d{4}(?!\\d{2}\\b))((-?)((0[1-9]|1[0-2])(\\3([12]\\d|0[1-9]|3[01]))?|W([0-4]\\d|5[0-2])(-?[1-7])?|(00[1-9]|0[1-9]\\d|[12]\\d{2}|3([0-5]\\d|6[1-6])))([T\\s]((([01]\\d|2[0-3])((:?)[0-5]\\d)?|24\\:?00)([\\.,]\\d+(?!:))?)?(\\17[0-5]\\d([\\.,]\\d+)?)?([zZ]|([\\+-])([01]\\d|2[0-3]):?([0-5]\\d)?)?)?)?$", date)) {
                            Range annotationRange2 = PositionUtils.toNameRange(annotation, context.getUtils());
                            String diagnosticMessage = Messages.getMessage("AnnotationMustDefineAttributeFollowing8601", "@Generated", "date");
                            diagnostics.add(context.createDiagnostic(uri, diagnosticMessage, annotationRange2, "jakarta-annotations", ErrorCode.InvalidDateFormat, DiagnosticSeverity.Error));
                        }
                        ++methods;
                    }
                } else if (DiagnosticUtils.isMatchedAnnotation(unit, annotation, "jakarta.annotation.Resource")) {
                    IType type;
                    if (element instanceof IType && (type = (IType)element).getElementType() == 7 && type.isClass()) {
                        Range annotationRange = PositionUtils.toNameRange(annotation, context.getUtils());
                        Boolean nameEmpty = true;
                        Boolean typeEmpty = true;
                        IMemberValuePair[] annotation2 = annotation.getMemberValuePairs();
                        int diagnosticMessage = annotation2.length;
                        int annotationRange2 = 0;
                        while (annotationRange2 < diagnosticMessage) {
                            IMemberValuePair pair = annotation2[annotationRange2];
                            if (pair.getMemberName().equals("name")) {
                                nameEmpty = false;
                            }
                            if (pair.getMemberName().equals("type")) {
                                typeEmpty = false;
                            }
                            ++annotationRange2;
                        }
                        if (nameEmpty.booleanValue()) {
                            String diagnosticMessage2 = Messages.getMessage("AnnotationMustDefineAttribute", "@Resource", "name");
                            diagnostics.add(context.createDiagnostic(uri, diagnosticMessage2, annotationRange, "jakarta-annotations", ErrorCode.MissingResourceNameAttribute, DiagnosticSeverity.Error));
                        }
                        if (typeEmpty.booleanValue()) {
                            String diagnosticMessage3 = Messages.getMessage("AnnotationMustDefineAttribute", "@Resource", "type");
                            diagnostics.add(context.createDiagnostic(uri, diagnosticMessage3, annotationRange, "jakarta-annotations", ErrorCode.MissingResourceTypeAttribute, DiagnosticSeverity.Error));
                        }
                    }
                } else if (DiagnosticUtils.isMatchedAnnotation(unit, annotation, "jakarta.annotation.Resources") && element instanceof IType) {
                    iTypeArray = annotation.getMemberValuePairs();
                    int nameEmpty = iTypeArray.length;
                    int annotationRange = 0;
                    while (annotationRange < nameEmpty) {
                        String diagnosticMessage;
                        IType internalAnnotation = iTypeArray[annotationRange];
                        Object[] valuePairs = (Object[])internalAnnotation.getValue();
                        Range annotationRange3 = null;
                        if (valuePairs.length == 0) {
                            annotationRange3 = PositionUtils.toNameRange(annotation, context.getUtils());
                            diagnosticMessage = Messages.getMessage("ResourcesAnnotationMustDefineResourceAnnotation", "@Resources", "@Resource");
                            diagnostics.add(context.createDiagnostic(uri, diagnosticMessage, annotationRange3, "jakarta-annotations", ErrorCode.MissingResourceAnnotation, DiagnosticSeverity.Error));
                        }
                        int objKind = internalAnnotation.getValueKind();
                        Object[] objectArray = valuePairs;
                        int n14 = valuePairs.length;
                        n = 0;
                        while (n < n14) {
                            IType type;
                            IAnnotation childAnnotation;
                            Object childAnnotationObj = objectArray[n];
                            if (objKind == 10 && DiagnosticUtils.isMatchedAnnotation(unit, childAnnotation = (IAnnotation)childAnnotationObj, "jakarta.annotation.Resource") && element instanceof IType && (type = (IType)element).getElementType() == 7 && type.isClass()) {
                                annotationRange3 = PositionUtils.toNameRange(childAnnotation, context.getUtils());
                                Boolean nameEmpty2 = true;
                                Boolean typeEmpty = true;
                                IMemberValuePair[] iMemberValuePairArray = childAnnotation.getMemberValuePairs();
                                int n15 = iMemberValuePairArray.length;
                                int n16 = 0;
                                while (n16 < n15) {
                                    IMemberValuePair pair = iMemberValuePairArray[n16];
                                    if (pair.getMemberName().equals("name")) {
                                        nameEmpty2 = false;
                                    }
                                    if (pair.getMemberName().equals("type")) {
                                        typeEmpty = false;
                                    }
                                    ++n16;
                                }
                                if (nameEmpty2.booleanValue()) {
                                    diagnosticMessage = Messages.getMessage("AnnotationMustDefineAttribute", "@Resource", "name");
                                    diagnostics.add(context.createDiagnostic(uri, diagnosticMessage, annotationRange3, "jakarta-annotations", ErrorCode.MissingResourceNameAttribute, DiagnosticSeverity.Error));
                                }
                                if (typeEmpty.booleanValue()) {
                                    diagnosticMessage = Messages.getMessage("AnnotationMustDefineAttribute", "@Resource", "type");
                                    diagnostics.add(context.createDiagnostic(uri, diagnosticMessage, annotationRange3, "jakarta-annotations", ErrorCode.MissingResourceTypeAttribute, DiagnosticSeverity.Error));
                                }
                            }
                            ++n;
                        }
                        ++annotationRange;
                    }
                }
                if (DiagnosticUtils.isMatchedAnnotation(unit, annotation, "jakarta.annotation.PostConstruct")) {
                    if (!(element instanceof IMethod)) continue;
                    method = (IMethod)element;
                    Range methodRange = PositionUtils.toNameRange(method, context.getUtils());
                    if (method.getNumberOfParameters() != 0) {
                        String diagnosticMessage = Messages.getMessage("MethodMustNotHaveParameters", "@PostConstruct");
                        diagnostics.add(context.createDiagnostic(uri, diagnosticMessage, methodRange, "jakarta-annotations", ErrorCode.PostConstructParams, DiagnosticSeverity.Error));
                    }
                    if (!method.getReturnType().equals("V")) {
                        String diagnosticMessage = Messages.getMessage("MethodMustBeVoid", "@PostConstruct");
                        diagnostics.add(context.createDiagnostic(uri, diagnosticMessage, methodRange, "jakarta-annotations", ErrorCode.PostConstructReturnType, DiagnosticSeverity.Error));
                    }
                    if (method.getExceptionTypes().length == 0) continue;
                    String diagnosticMessage = Messages.getMessage("MethodMustNotThrow", "@PostConstruct");
                    diagnostics.add(context.createDiagnostic(uri, diagnosticMessage, methodRange, "jakarta-annotations", ErrorCode.PostConstructException, DiagnosticSeverity.Warning));
                    continue;
                }
                if (!DiagnosticUtils.isMatchedAnnotation(unit, annotation, "jakarta.annotation.PreDestroy") || !(element instanceof IMethod)) continue;
                method = (IMethod)element;
                Range methodRange = PositionUtils.toNameRange(method, context.getUtils());
                if (method.getNumberOfParameters() != 0) {
                    String diagnosticMessage = Messages.getMessage("MethodMustNotHaveParameters", "@PreDestroy");
                    diagnostics.add(context.createDiagnostic(uri, diagnosticMessage, methodRange, "jakarta-annotations", ErrorCode.PreDestroyParams, DiagnosticSeverity.Error));
                }
                if (Flags.isStatic((int)method.getFlags())) {
                    String diagnosticMessage = Messages.getMessage("MethodMustNotBeStatic", "@PreDestroy");
                    diagnostics.add(context.createDiagnostic(uri, diagnosticMessage, methodRange, "jakarta-annotations", ErrorCode.PreDestroyStatic, DiagnosticSeverity.Error));
                }
                if (method.getExceptionTypes().length == 0) continue;
                String diagnosticMessage = Messages.getMessage("MethodMustNotThrow", "@PreDestroy");
                diagnostics.add(context.createDiagnostic(uri, diagnosticMessage, methodRange, "jakarta-annotations", ErrorCode.PreDestroyException, DiagnosticSeverity.Warning));
            }
        }
        return diagnostics;
    }

    private static boolean isValidAnnotation(String annotationName, String[] validAnnotations) {
        String[] stringArray = validAnnotations;
        int n = validAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            String fqName = stringArray[n2];
            if (fqName.endsWith(annotationName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

