/**
 * Copyright (c) 2016-2018 TypeFox and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j;

import org.eclipse.lsp4j.jsonrpc.ProtocolDraft;
import org.eclipse.lsp4j.jsonrpc.ProtocolSince;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;

/**
 * Text document specific server capabilities.
 */
@ProtocolDraft
@ProtocolSince("3.18.0")
@SuppressWarnings("all")
public class TextDocumentServerCapabilities {
  /**
   * Capabilities specific to the diagnostic pull model.
   */
  private DiagnosticServerCapabilities diagnostic;

  public TextDocumentServerCapabilities() {
  }

  /**
   * Capabilities specific to the diagnostic pull model.
   */
  public DiagnosticServerCapabilities getDiagnostic() {
    return this.diagnostic;
  }

  /**
   * Capabilities specific to the diagnostic pull model.
   */
  public void setDiagnostic(final DiagnosticServerCapabilities diagnostic) {
    this.diagnostic = diagnostic;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("diagnostic", this.diagnostic);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    TextDocumentServerCapabilities other = (TextDocumentServerCapabilities) obj;
    if (this.diagnostic == null) {
      if (other.diagnostic != null)
        return false;
    } else if (!this.diagnostic.equals(other.diagnostic))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    return 31 * 1 + ((this.diagnostic== null) ? 0 : this.diagnostic.hashCode());
  }
}
