/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.conformance.ui;

import activity.Activity;
import activity.ActivitySet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.lsat.common.emf.common.util.URIHelper;
import org.eclipse.lsat.common.emf.ecore.resource.Persistor;
import org.eclipse.lsat.common.emf.ecore.resource.PersistorFactory;
import org.eclipse.lsat.common.emf.ui.model.ModelWorkbenchContentProvider;
import org.eclipse.lsat.common.emf.ui.model.ModelWorkbenchLabelProvider;
import org.eclipse.lsat.conformance.FilterTPTracePointsInput;
import org.eclipse.lsat.conformance.FilterTPTracePointsJava;
import org.eclipse.lsat.conformance.ui.Activator;
import org.eclipse.lsat.trace.TraceModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class FilterTPTraceAction
extends ActionDelegate {
    private List<IFile> files = Collections.emptyList();

    public void selectionChanged(IAction action, ISelection selection) {
        this.files = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toList() : Collections.emptyList();
    }

    public void run(IAction action) {
        if (!this.files.isEmpty()) {
            try {
                final List<Activity> activities = this.selectActivities();
                if (activities == null || activities.isEmpty()) {
                    return;
                }
                IRunnableWithProgress operation = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        FilterTPTraceAction.this.runWithProgress(monitor, activities);
                    }
                };
                PlatformUI.getWorkbench().getProgressService().run(true, true, operation);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.lsat.conformance.ui", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    private void runWithProgress(IProgressMonitor monitor, List<Activity> activities) {
        try {
            try {
                monitor.beginTask("Filtering trace files", this.files.size());
                for (IFile modelIFile : this.files) {
                    monitor.subTask("Filtering " + modelIFile.getName());
                    PersistorFactory factory = new PersistorFactory();
                    URI modelURI = URIHelper.asURI((IResource)modelIFile);
                    Persistor tracePersistor = factory.getPersistor(TraceModel.class);
                    TraceModel trace = (TraceModel)tracePersistor.loadOne(modelURI);
                    FilterTPTracePointsJava filterTPTracePoints = new FilterTPTracePointsJava();
                    List traces = filterTPTracePoints.transformModel(new FilterTPTracePointsInput(activities, trace));
                    tracePersistor.save(modelURI, new Collection[]{traces});
                    monitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    break;
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.lsat.conformance.ui", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Filter trace files", (String)("Filter trace files failed:\n" + e.getMessage() + "\n\nSee Error Log for details."));
                    }
                });
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private List<Activity> selectActivities() {
        ModelWorkbenchLabelProvider modelWorkbenchLabelProvider = new ModelWorkbenchLabelProvider(new AdapterFactory[0]);
        ModelWorkbenchContentProvider modelWorkbenchContentProvider = new ModelWorkbenchContentProvider(new AdapterFactory[]{modelWorkbenchLabelProvider.getAdapterFactory()});
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)modelWorkbenchLabelProvider, (ITreeContentProvider)modelWorkbenchContentProvider);
        dialog.setTitle("Select activities");
        dialog.setMessage("Select activities to filter from trace");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return Objects.equals("activity", ((IFile)element).getFileExtension());
                }
                return element instanceof IContainer || element instanceof ActivitySet || element instanceof Activity;
            }
        });
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length <= 0) {
                    return new Status(4, "org.eclipse.lsat.conformance.ui", 0, "Please select one or more activities!", null);
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selected = objectArray[n2];
                    if (!(selected instanceof Activity)) {
                        return new Status(4, "org.eclipse.lsat.conformance.ui", 0, "Only activity selection is allowed!", null);
                    }
                    ++n2;
                }
                return new Status(0, "org.eclipse.lsat.conformance.ui", 0, "OK", null);
            }
        });
        dialog.open();
        return dialog.getResult() == null ? null : (List)List.class.cast(Arrays.asList(dialog.getResult()));
    }
}

