/**
 */
package distributions.util;

import distributions.*;

import expressions.AbstractElement;
import expressions.Expression;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see distributions.DistributionsPackage
 * @generated
 */
public class DistributionsSwitch<T> extends Switch<T>
{
    /**
     * The cached model package
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static DistributionsPackage modelPackage;

    /**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public DistributionsSwitch()
    {
        if (modelPackage == null)
        {
            modelPackage = DistributionsPackage.eINSTANCE;
        }
    }

    /**
     * Checks whether this is a switch for the given package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param ePackage the package in question.
     * @return whether this is a switch for the given package.
     * @generated
     */
    @Override
    protected boolean isSwitchFor(EPackage ePackage)
    {
        return ePackage == modelPackage;
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    @Override
    protected T doSwitch(int classifierID, EObject theEObject)
    {
        switch (classifierID)
        {
            case DistributionsPackage.DISTRIBUTION:
            {
                Distribution distribution = (Distribution)theEObject;
                T result = caseDistribution(distribution);
                if (result == null) result = caseExpression(distribution);
                if (result == null) result = caseAbstractElement(distribution);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DistributionsPackage.TRIANGULAR_DISTRIBUTION:
            {
                TriangularDistribution triangularDistribution = (TriangularDistribution)theEObject;
                T result = caseTriangularDistribution(triangularDistribution);
                if (result == null) result = caseDistribution(triangularDistribution);
                if (result == null) result = caseExpression(triangularDistribution);
                if (result == null) result = caseAbstractElement(triangularDistribution);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DistributionsPackage.PERT_DISTRIBUTION:
            {
                PertDistribution pertDistribution = (PertDistribution)theEObject;
                T result = casePertDistribution(pertDistribution);
                if (result == null) result = caseDistribution(pertDistribution);
                if (result == null) result = caseExpression(pertDistribution);
                if (result == null) result = caseAbstractElement(pertDistribution);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DistributionsPackage.NORMAL_DISTRIBUTION:
            {
                NormalDistribution normalDistribution = (NormalDistribution)theEObject;
                T result = caseNormalDistribution(normalDistribution);
                if (result == null) result = caseDistribution(normalDistribution);
                if (result == null) result = caseExpression(normalDistribution);
                if (result == null) result = caseAbstractElement(normalDistribution);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DistributionsPackage.ENUMERATED_DISTRIBUTION:
            {
                EnumeratedDistribution enumeratedDistribution = (EnumeratedDistribution)theEObject;
                T result = caseEnumeratedDistribution(enumeratedDistribution);
                if (result == null) result = caseDistribution(enumeratedDistribution);
                if (result == null) result = caseExpression(enumeratedDistribution);
                if (result == null) result = caseAbstractElement(enumeratedDistribution);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DistributionsPackage.GAMMA_DISTRIBUTION:
            {
                GammaDistribution gammaDistribution = (GammaDistribution)theEObject;
                T result = caseGammaDistribution(gammaDistribution);
                if (result == null) result = caseDistribution(gammaDistribution);
                if (result == null) result = caseExpression(gammaDistribution);
                if (result == null) result = caseAbstractElement(gammaDistribution);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DistributionsPackage.POISSON_DISTRIBUTION:
            {
                PoissonDistribution poissonDistribution = (PoissonDistribution)theEObject;
                T result = casePoissonDistribution(poissonDistribution);
                if (result == null) result = caseDistribution(poissonDistribution);
                if (result == null) result = caseExpression(poissonDistribution);
                if (result == null) result = caseAbstractElement(poissonDistribution);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case DistributionsPackage.LOG_NORMAL_DISTRIBUTION:
            {
                LogNormalDistribution logNormalDistribution = (LogNormalDistribution)theEObject;
                T result = caseLogNormalDistribution(logNormalDistribution);
                if (result == null) result = caseDistribution(logNormalDistribution);
                if (result == null) result = caseExpression(logNormalDistribution);
                if (result == null) result = caseAbstractElement(logNormalDistribution);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Distribution</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Distribution</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseDistribution(Distribution object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Triangular Distribution</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Triangular Distribution</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseTriangularDistribution(TriangularDistribution object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Pert Distribution</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Pert Distribution</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T casePertDistribution(PertDistribution object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Normal Distribution</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Normal Distribution</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseNormalDistribution(NormalDistribution object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Enumerated Distribution</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Enumerated Distribution</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseEnumeratedDistribution(EnumeratedDistribution object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Gamma Distribution</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Gamma Distribution</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseGammaDistribution(GammaDistribution object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Poisson Distribution</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Poisson Distribution</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T casePoissonDistribution(PoissonDistribution object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Log Normal Distribution</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Log Normal Distribution</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseLogNormalDistribution(LogNormalDistribution object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Abstract Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Abstract Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseAbstractElement(AbstractElement object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseExpression(Expression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch, but this is the last case anyway.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
    @Override
    public T defaultCase(EObject object)
    {
        return null;
    }

} //DistributionsSwitch
